/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.table.TableEventHandler;

public class TableMetaData<E>
implements TableEventHandler<E>,
Serializable {
    private static final long serialVersionUID = -7072099446189045388L;
    private List<String> columnTitleList = new ArrayList<String>();
    private List<String> rowTitleList = new ArrayList<String>();
    private String tableName = null;

    public int getColumnIndex(Pattern columnTitlePattern) {
        for (int ii = 0; ii < this.columnTitleList.size(); ++ii) {
            String columnTitle = this.columnTitleList.get(ii);
            if (!columnTitlePattern.matcher(columnTitle).matches()) continue;
            return ii;
        }
        return -1;
    }

    public int getColumnIndex(String columnTitle) {
        return this.columnTitleList.indexOf(columnTitle);
    }

    public BitSet getColumnIndexFilter(Pattern columnTitlePattern) {
        BitSet retval = new BitSet();
        for (int ii = 0; ii < this.columnTitleList.size(); ++ii) {
            String columnTitle = this.columnTitleList.get(ii);
            if (!columnTitlePattern.matcher(columnTitle).matches()) continue;
            retval.set(ii);
        }
        return retval;
    }

    public BitSet getColumnIndexFilter(Set<String> columnTitleSet) {
        BitSet retval = new BitSet();
        if (columnTitleSet != null) {
            for (int ii = 0; ii < this.columnTitleList.size(); ++ii) {
                String columnTitle = this.columnTitleList.get(ii);
                if (!columnTitleSet.contains(columnTitle)) continue;
                retval.set(ii);
            }
        }
        return retval;
    }

    public String getColumnTitle(int columnIndex) {
        return (String)ListUtils.get(this.columnTitleList, (int)columnIndex);
    }

    public List<String> getColumnTitleList() {
        return Collections.unmodifiableList(this.columnTitleList);
    }

    public int getRowIndex(String rowTitle) {
        return this.rowTitleList.indexOf(rowTitle);
    }

    public String getRowTitle(int rowIndex) {
        return (String)ListUtils.get(this.rowTitleList, (int)rowIndex);
    }

    public List<String> getRowTitleList() {
        return Collections.unmodifiableList(this.rowTitleList);
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void handleAddedColumn(int columnIndex, E ... elements) {
        ListUtils.add(this.columnTitleList, (int)columnIndex, (Object)null);
    }

    @Override
    public void handleAddedRow(int rowIndex, E ... elements) {
        ListUtils.add(this.rowTitleList, (int)rowIndex, (Object)null);
    }

    @Override
    public void handleClearTable() {
        this.columnTitleList.clear();
        this.rowTitleList.clear();
    }

    @Override
    public void handleRemovedColumn(int columnIndex, E[] previousElements, String columnTitle) {
        ListUtils.remove(this.columnTitleList, (int)columnIndex);
    }

    @Override
    public void handleRemovedRow(int rowIndex, E[] previousElements, String rowTitle) {
        ListUtils.remove(this.rowTitleList, (int)rowIndex);
    }

    @Override
    public void handleUpdatedCell(int rowIndex, int columnIndex, E element, E previousElement) {
    }

    @Override
    public void handleUpdatedRow(int rowIndex, E[] elements, E[] previousElements, BitSet modifiedIndices) {
    }

    public boolean hasColumnTitles() {
        boolean hasColumnTitles = !ListUtils.filterExcludingNullElements(this.columnTitleList).isEmpty();
        return hasColumnTitles;
    }

    public boolean hasRowTitles() {
        boolean hasRowTitles = !ListUtils.filterExcludingNullElements(this.rowTitleList).isEmpty();
        return hasRowTitles;
    }

    public boolean hasTableName() {
        return this.tableName != null;
    }

    public String setColumnTitle(int columnIndex, String columnTitle) {
        String retval = (String)ListUtils.get(this.columnTitleList, (int)columnIndex);
        ListUtils.set(this.columnTitleList, (int)columnIndex, (Object)columnTitle);
        return retval;
    }

    public String[] setColumnTitles(String[] columnTitles) {
        String[] retvals = this.columnTitleList.toArray(new String[0]);
        this.columnTitleList.clear();
        ListUtils.addAll(this.columnTitleList, (Object[])columnTitles);
        return retvals;
    }

    public String setRowTitle(int rowIndex, String rowTitle) {
        String retval = (String)ListUtils.get(this.rowTitleList, (int)rowIndex);
        ListUtils.set(this.rowTitleList, (int)rowIndex, (Object)rowTitle);
        return retval;
    }

    public String[] setRowTitles(String[] rowTitles) {
        String[] retvals = this.rowTitleList.toArray(new String[0]);
        this.rowTitleList.clear();
        ListUtils.addAll(this.rowTitleList, (Object[])rowTitles);
        return retvals;
    }

    public String setTableName(String tableName) {
        String retval = this.tableName;
        this.tableName = tableName;
        return retval;
    }

    @Override
    public void handleModifiedColumnTitle(int columnIndex, String columnTitle, String columnTitlePrevious) {
    }

    @Override
    public void handleModifiedRowTitle(int rowIndex, String rowTitle, String rowTitlePrevious) {
    }

    @Override
    public void handleModifiedColumnTitles(String[] columnTitles, String[] columnTitlesPrevious) {
    }

    @Override
    public void handleModifiedRowTitles(String[] rowTitles, String[] rowTitlesPrevious) {
    }

    @Override
    public void handleModifiedTableName(String tableName, String tableNamePrevious) {
    }
}

