/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl;

import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.collections.ComparatorUtils;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.collection.list.ListAbstract;
import org.omnaest.utils.structure.element.cached.CachedElement;
import org.omnaest.utils.table.ImmutableColumn;
import org.omnaest.utils.table.StripeEntity;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableExecution;
import org.omnaest.utils.table.TableSorter;

final class TableSorterImpl<E>
implements TableSorter<E> {
    private static final long serialVersionUID = 7658083106342074763L;
    private boolean useTableLock = false;
    private Comparator<E> comparator = ComparatorUtils.NATURAL_COMPARATOR;
    private final Table<E> table;

    TableSorterImpl(Table<E> table) {
        this.table = table;
    }

    @Override
    public Table<E> by(final ImmutableColumn<E> column) {
        int rowSize = this.table.rowSize();
        Comparator rowIndexComparator = new Comparator<StripeEntity<E>>(){
            private CachedElement<Integer> columnIndex = new CachedElement((CachedElement.ValueResolver)new CachedElement.ValueResolver<Integer>(){

                public Integer resolveValue() {
                    return column.index();
                }
            });

            @Override
            public int compare(StripeEntity<E> stripeEntity1, StripeEntity<E> stripeEntity2) {
                int columnIndex = (Integer)this.columnIndex.getValue();
                Object element1 = stripeEntity1.getElements()[columnIndex];
                Object element2 = stripeEntity2.getElements()[columnIndex];
                return TableSorterImpl.this.comparator.compare(element1, element2);
            }
        };
        SortExecution<E> tableExecution = new SortExecution<E>(rowIndexComparator, rowSize);
        if (this.useTableLock) {
            this.table.executeWithWriteLock(tableExecution);
        } else {
            tableExecution.execute(this.table);
        }
        return this.table;
    }

    @Override
    public Table<E> by(int columnIndex) {
        return this.by(this.table.column(columnIndex));
    }

    @Override
    public TableSorter<E> using(Comparator<E> comparator) {
        Assert.isNotNull(comparator, (String)"Comparator must not be null");
        this.comparator = comparator;
        return this;
    }

    @Override
    public TableSorter<E> withTableLock() {
        this.useTableLock = true;
        return this;
    }

    private static final class SortExecution<E>
    implements TableExecution<Table<E>, E> {
        private final Comparator<StripeEntity<E>> rowIndexComparator;
        private final int rowSize;

        SortExecution(Comparator<StripeEntity<E>> rowIndexComparator, int rowSize) {
            this.rowIndexComparator = rowIndexComparator;
            this.rowSize = rowSize;
        }

        @Override
        public void execute(final Table<E> table) {
            Collections.sort(new ListAbstract<StripeEntity<E>>(){
                private static final long serialVersionUID = -4874801955229108199L;

                public int indexOf(Object o) {
                    throw new UnsupportedOperationException();
                }

                public int lastIndexOf(Object o) {
                    throw new UnsupportedOperationException();
                }

                public int size() {
                    return SortExecution.this.rowSize;
                }

                public boolean add(StripeEntity<E> e) {
                    throw new UnsupportedOperationException();
                }

                public StripeEntity<E> get(int index) {
                    return table.row(index).to().entity();
                }

                public StripeEntity<E> set(int index, StripeEntity<E> stripeEntity) {
                    Object retval = this.get(index);
                    table.setRowElements(index, stripeEntity.getElements());
                    table.setRowTitle(index, stripeEntity.getTitle());
                    return retval;
                }

                public void add(int index, StripeEntity<E> element) {
                    throw new UnsupportedOperationException();
                }

                public StripeEntity<E> remove(int index) {
                    throw new UnsupportedOperationException();
                }
            }, this.rowIndexComparator);
        }
    }
}

