/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.adapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.omnaest.utils.operation.Operation;
import org.omnaest.utils.structure.map.MapAbstract;
import org.omnaest.utils.table.Cell;
import org.omnaest.utils.table.ImmutableStripe;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableIndex;

class OneColumnToMapAdapter<E>
extends MapAbstract<E, Set<Row<E>>> {
    private static final long serialVersionUID = -195168418120399979L;
    private final Table<E> table;
    private TableIndex<E, Cell<E>> index;

    OneColumnToMapAdapter(Table<E> table, int columnIndexKey) {
        this.table = table;
        this.index = this.table.index().of(columnIndexKey);
    }

    public Set<Row<E>> get(Object key) {
        LinkedHashSet<Row<E>> retset = new LinkedHashSet<Row<E>>();
        Operation operation = new Operation<Row<E>, Row<E>>(){

            public Row<E> execute(Row<E> row) {
                return row;
            }
        };
        this.executeOnMatchingRows(key, retset, operation);
        return retset;
    }

    private void executeOnMatchingRows(Object key, Set<Row<E>> retset, Operation<Row<E>, Row<E>> operation) {
        Set cellSet = (Set)this.index.get(key);
        if (cellSet != null) {
            for (Cell cell : cellSet) {
                Row row;
                if (cell == null || (row = cell.row()) == null) continue;
                retset.add((Row<Object>)operation.execute(row));
            }
        }
    }

    public Set<Row<E>> put(E key, Set<Row<E>> newRowSet) {
        LinkedHashSet<Row<E>> retset = new LinkedHashSet<Row<E>>();
        final Iterator<Row<Row<E>>> iterator = newRowSet != null ? newRowSet.iterator() : null;
        Operation operation = new Operation<Row<E>, Row<E>>(){

            public Row<E> execute(Row<E> row) {
                Row rowPrevious = row;
                ImmutableStripe newRow = iterator != null && iterator.hasNext() ? (Row)iterator.next() : null;
                row.setElements(newRow.getElements());
                return rowPrevious;
            }
        };
        this.executeOnMatchingRows(key, retset, operation);
        return retset;
    }

    public Set<Row<E>> remove(Object key) {
        LinkedHashSet<Row<E>> retset = new LinkedHashSet<Row<E>>();
        Operation operation = new Operation<Row<E>, Row<E>>(){

            public Row<E> execute(Row<E> row) {
                row.remove();
                return row;
            }
        };
        this.executeOnMatchingRows(key, retset, operation);
        return retset;
    }

    public Set<E> keySet() {
        return this.index.keySet();
    }

    public Collection<Set<Row<E>>> values() {
        throw new UnsupportedOperationException();
    }
}

