/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.adapter;

import java.sql.ResultSet;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.beans.replicator.BeanReplicator;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterIdentity;
import org.omnaest.utils.structure.map.MapUtils;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableAdapterManager;
import org.omnaest.utils.table.impl.adapter.OneColumnToMapAdapter;
import org.omnaest.utils.table.impl.adapter.TableToListUsingDTOsAdapter;
import org.omnaest.utils.table.impl.adapter.TableToListUsingManagedBeansAdapter;
import org.omnaest.utils.table.impl.adapter.TableToResultSetAdapter;
import org.omnaest.utils.table.impl.adapter.TwoColumnToMapAdapter;

public class TableAdapterManagerImpl<E>
implements TableAdapterManager<E> {
    private static final long serialVersionUID = -4405457601074880665L;
    private final Table<E> table;
    private final ExceptionHandler exceptionHandler;

    public TableAdapterManagerImpl(Table<E> table, ExceptionHandler exceptionHandler) {
        this.table = table;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public Map<E, Set<E>> map(int columnIndexKey, int columnIndexValue) {
        return new TwoColumnToMapAdapter<E>(this.table, columnIndexKey, columnIndexValue);
    }

    @Override
    public Map<E, Set<Row<E>>> map(int columnIndexKey) {
        return new OneColumnToMapAdapter<E>(this.table, columnIndexKey);
    }

    @Override
    public Map<E, BitSet> rowIndexMap(int columnIndexKey) {
        ElementBidirectionalConverter elementBidirectionalConverterValue = new ElementBidirectionalConverter<Set<Row<E>>, BitSet>(){

            public BitSet convert(Set<Row<E>> rowSet) {
                BitSet retval = new BitSet();
                if (rowSet != null) {
                    for (Row row : rowSet) {
                        retval.set(row.index());
                    }
                }
                return retval;
            }

            public Set<Row<E>> convertBackwards(BitSet element) {
                throw new UnsupportedOperationException();
            }
        };
        return MapUtils.adapter(this.map(columnIndexKey), (ElementBidirectionalConverter)new ElementConverterIdentity(), (ElementBidirectionalConverter)elementBidirectionalConverterValue);
    }

    @Override
    public <B> List<B> managedBeanList(Class<? extends B> type) {
        return new TableToListUsingManagedBeansAdapter<E, B>(this.table, type, this.exceptionHandler);
    }

    @Override
    public <B> List<B> managedBeanList(Class<? extends B> type, BeanReplicator.Declaration declaration) {
        return new TableToListUsingManagedBeansAdapter<E, B>(this.table, type, declaration, this.exceptionHandler);
    }

    @Override
    public <B> List<B> beanList(Class<? extends B> type) {
        return new TableToListUsingDTOsAdapter<E, B>(this.table, type, this.exceptionHandler);
    }

    @Override
    public <B> List<B> beanList(Class<? extends B> type, BeanReplicator.Declaration declaration) {
        return new TableToListUsingDTOsAdapter<E, B>(this.table, type, declaration, this.exceptionHandler);
    }

    @Override
    public ResultSet resultSet() {
        return new TableToResultSetAdapter(this.table);
    }
}

