/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.adapter;

import java.util.Map;
import org.omnaest.utils.beans.replicator.BeanReplicator;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.collection.list.ListAbstract;
import org.omnaest.utils.structure.map.MapUtils;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.Table;

class TableToListUsingDTOsAdapter<E, B>
extends ListAbstract<B> {
    private static final long serialVersionUID = -5899940297760214750L;
    private final BeanReplicator<B, Map> beanReplicatorBeanToRow;
    private final BeanReplicator<Map, B> beanReplicatorRowToBean;
    private final Table<E> table;

    TableToListUsingDTOsAdapter(Table<E> table, Class<? extends B> beanType, BeanReplicator.Declaration declaration, ExceptionHandler exceptionHandler) {
        this.table = table;
        this.beanReplicatorBeanToRow = new BeanReplicator(beanType, Map.class).declare(declaration).setExceptionHandler(exceptionHandler);
        this.beanReplicatorRowToBean = new BeanReplicator(Map.class, beanType).declare(declaration).setExceptionHandler(exceptionHandler);
    }

    TableToListUsingDTOsAdapter(Table<E> table, Class<? extends B> beanType, ExceptionHandler exceptionHandler) {
        this(table, beanType, new BeanReplicator.Declaration(){
            private static final long serialVersionUID = -5488806350640682134L;

            public void declare(BeanReplicator.DeclarationSupport support) {
                support.setPreservedDeepnessLevel(1);
            }
        }, exceptionHandler);
    }

    public int size() {
        return this.table.rowSize();
    }

    public boolean add(B bean) {
        int index = this.size();
        this.add(index, bean);
        return true;
    }

    public B get(int index) {
        boolean detached = true;
        Row<E> row = this.table.row(index, true);
        Map map = row.to().map();
        Object retval = this.beanReplicatorRowToBean.clone(map);
        return (B)retval;
    }

    public B set(int index, B bean) {
        B retval = this.get(index);
        if (bean != null) {
            Map map = (Map)this.beanReplicatorBeanToRow.clone(bean);
            Object[] elements = MapUtils.filteredValues((Map)map, this.table.elementType(), (Object[])this.table.getColumnTitles());
            this.table.setRowElements(index, elements);
        }
        return retval;
    }

    public void add(int index, B bean) {
        if (bean != null) {
            Map map = (Map)this.beanReplicatorBeanToRow.clone(bean);
            Object[] elements = MapUtils.filteredValues((Map)map, this.table.elementType(), (Object[])this.table.getColumnTitles());
            this.table.addRowElements(index, elements);
        }
    }

    public B remove(int index) {
        B retval = this.get(index);
        this.table.removeRow(index);
        return retval;
    }

    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }
}

