/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.adapter;

import org.omnaest.utils.beans.replicator.BeanReplicator;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.collection.list.ListAbstract;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.impl.rowdata.RowDataBasedBeanFactory;

class TableToListUsingManagedBeansAdapter<E, B>
extends ListAbstract<B> {
    private static final long serialVersionUID = -5899940297760214750L;
    private final RowDataBasedBeanFactory<B> beanFactory;
    private final BeanReplicator<B, B> beanReplicator;
    private final Table<E> table;

    TableToListUsingManagedBeansAdapter(Table<E> table, Class<? extends B> beanType, BeanReplicator.Declaration declaration, ExceptionHandler exceptionHandler) {
        this.table = table;
        this.beanFactory = new RowDataBasedBeanFactory<B>(beanType, exceptionHandler);
        this.beanReplicator = new BeanReplicator(beanType, beanType).declare(declaration).setExceptionHandler(exceptionHandler);
    }

    TableToListUsingManagedBeansAdapter(Table<E> table, Class<? extends B> beanType, ExceptionHandler exceptionHandler) {
        this(table, beanType, new BeanReplicator.Declaration(){
            private static final long serialVersionUID = -8682578614622766973L;

            public void declare(BeanReplicator.DeclarationSupport support) {
                support.setPreservedDeepnessLevel(1);
            }
        }, exceptionHandler);
    }

    public int size() {
        return this.table.rowSize();
    }

    public boolean add(B bean) {
        int index = this.size();
        this.add(index, bean);
        return true;
    }

    public B get(int index) {
        Row<E> row = this.table.row(index);
        B retval = this.beanFactory.build(row);
        return retval;
    }

    public B set(int index, B bean) {
        B accessBean = this.get(index);
        Object retval = this.beanReplicator.clone(accessBean);
        if (bean != null) {
            this.beanReplicator.copy(bean, accessBean);
        }
        return (B)retval;
    }

    public void add(int index, B bean) {
        Row<E> row = this.table.newRow();
        if (bean != null) {
            B accessBean = this.beanFactory.build(row);
            this.beanReplicator.copy(bean, accessBean);
            row.moveTo(index);
        }
    }

    public B remove(int index) {
        B retval = this.get(index);
        this.table.removeRow(index);
        return retval;
    }

    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }
}

