/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.adapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.omnaest.utils.operation.Operation;
import org.omnaest.utils.structure.map.MapAbstract;
import org.omnaest.utils.table.Cell;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableIndex;

class TwoColumnToMapAdapter<E>
extends MapAbstract<E, Set<E>> {
    private static final long serialVersionUID = -195168418120399979L;
    private final Table<E> table;
    private final int columnIndexValue;
    private TableIndex<E, Cell<E>> index;

    TwoColumnToMapAdapter(Table<E> table, int columnIndexKey, int columnIndexValue) {
        this.table = table;
        this.columnIndexValue = columnIndexValue;
        this.index = this.table.index().of(columnIndexKey);
    }

    public Set<E> get(Object key) {
        LinkedHashSet retset = new LinkedHashSet();
        Operation operation = new Operation<E, Row<E>>(){

            public E execute(Row<E> row) {
                Object element = row.getElement(TwoColumnToMapAdapter.this.columnIndexValue);
                return element;
            }
        };
        this.executeOnMatchingRows(key, retset, operation);
        return retset;
    }

    private void executeOnMatchingRows(Object key, Set<E> retset, Operation<E, Row<E>> operation) {
        Set cellSet = (Set)this.index.get(key);
        if (cellSet != null) {
            for (Cell cell : cellSet) {
                Row row;
                if (cell == null || (row = cell.row()) == null) continue;
                retset.add(operation.execute(row));
            }
        }
    }

    public Set<E> put(E key, Set<E> newElementSet) {
        LinkedHashSet retset = new LinkedHashSet();
        final Iterator<E> iterator = newElementSet != null ? newElementSet.iterator() : null;
        Operation operation = new Operation<E, Row<E>>(){

            public E execute(Row<E> row) {
                Object elementPrevious = row.getElement(TwoColumnToMapAdapter.this.columnIndexValue);
                Object newElement = iterator != null && iterator.hasNext() ? (Object)iterator.next() : null;
                row.setElement(TwoColumnToMapAdapter.this.columnIndexValue, newElement);
                return elementPrevious;
            }
        };
        this.executeOnMatchingRows(key, retset, operation);
        return retset;
    }

    public Set<E> remove(Object key) {
        LinkedHashSet retset = new LinkedHashSet();
        Operation operation = new Operation<E, Row<E>>(){

            public E execute(Row<E> row) {
                Object elementPrevious = null;
                Cell cell = row.cell(TwoColumnToMapAdapter.this.columnIndexValue);
                if (cell != null) {
                    elementPrevious = cell.clear();
                }
                return elementPrevious;
            }
        };
        this.executeOnMatchingRows(key, retset, operation);
        return retset;
    }

    public Set<E> keySet() {
        return this.index.keySet();
    }

    public Collection<Set<E>> values() {
        throw new UnsupportedOperationException();
    }
}

