/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.datasource;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.events.exception.basic.ExceptionHandlerDelegate;
import org.omnaest.utils.events.exception.basic.ExceptionHandlerIgnoring;
import org.omnaest.utils.table.TableDataSource;

public class TableDataSourceResultSet<E>
implements TableDataSource<E> {
    private static final long serialVersionUID = -9106875893967218350L;
    private final ResultSet resultSet;
    private final Class<E> elementType;
    private final ExceptionHandlerDelegate exceptionHandlerDelegate = new ExceptionHandlerDelegate((ExceptionHandler)new ExceptionHandlerIgnoring());

    public TableDataSourceResultSet(ResultSet resultSet, Class<E> elementType) {
        this.resultSet = resultSet;
        this.elementType = elementType;
    }

    @Override
    public String getTableName() {
        boolean column = true;
        try {
            return this.resultSet.getMetaData().getTableName(1);
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public String[] getColumnTitles() {
        ArrayList<String> retlist = new ArrayList<String>();
        try {
            ResultSetMetaData metaData = this.resultSet.getMetaData();
            if (metaData != null) {
                for (int columnIndexPosition = 1; columnIndexPosition <= metaData.getColumnCount(); ++columnIndexPosition) {
                    String columnName = metaData.getColumnName(columnIndexPosition);
                    retlist.add(columnName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retlist.toArray(new String[0]);
    }

    @Override
    public Iterable<E[]> rowElements() {
        final ResultSet resultSet = this.resultSet;
        final Class<E> elementType = this.elementType;
        ExceptionHandlerDelegate exceptionHandler = this.exceptionHandlerDelegate;
        return new Iterable<E[]>((ExceptionHandler)exceptionHandler){
            final /* synthetic */ ExceptionHandler val$exceptionHandler;
            {
                this.val$exceptionHandler = exceptionHandler;
            }

            @Override
            public Iterator<E[]> iterator() {
                return new Iterator<E[]>(){

                    @Override
                    public boolean hasNext() {
                        try {
                            return resultSet.next();
                        }
                        catch (SQLException e) {
                            return false;
                        }
                    }

                    @Override
                    public E[] next() {
                        Object[] retvals = null;
                        try {
                            int columnCount = resultSet.getMetaData().getColumnCount();
                            retvals = (Object[])Array.newInstance(elementType, columnCount);
                            for (int columnIndexPosition = 0; columnIndexPosition < columnCount; ++columnIndexPosition) {
                                retvals[columnIndexPosition] = resultSet.getObject(columnIndexPosition + 1);
                            }
                        }
                        catch (SQLException e) {
                            val$exceptionHandler.handleException((Exception)e);
                        }
                        return retvals;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandlerDelegate.setExceptionHandler(exceptionHandler);
    }

    @Override
    public String[] getRowTitles() {
        return null;
    }
}

