/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.join;

import com.google.common.base.Joiner;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.operation.foreach.Range;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.collection.CollectionUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.ElementHolder;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterIdentity;
import org.omnaest.utils.structure.element.factory.Factory;
import org.omnaest.utils.structure.element.factory.FactoryParameterized;
import org.omnaest.utils.structure.element.factory.concrete.LinkedHashSetFactory;
import org.omnaest.utils.structure.iterator.IterableUtils;
import org.omnaest.utils.structure.map.MapUtils;
import org.omnaest.utils.table.ImmutableColumn;
import org.omnaest.utils.table.ImmutableRow;
import org.omnaest.utils.table.ImmutableTable;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableExecution;
import org.omnaest.utils.table.TableSelect;
import org.omnaest.utils.table.impl.ArrayTable;

public class TableSelectImpl<E>
implements TableSelect<E>,
TableSelect.TableJoin<E>,
TableSelect.TableSelectExecution<E> {
    private List<TableSelect.Predicate<E>> predicateList = new ArrayList<TableSelect.Predicate<E>>();
    private List<ColumnJoin<E>> columnJoinList = new ArrayList<ColumnJoin<E>>();
    private List<Bucket<E>> closedBucketList = new ArrayList<Bucket<E>>();
    private Bucket<E> bucket;
    private Set<ImmutableTable<E>> tableForLockingSet = new LinkedHashSet<ImmutableTable<E>>();
    private int top = -1;
    private int skip = 0;

    public TableSelectImpl(Table<E> table) {
        this.bucket = new Bucket<E>(table);
    }

    @Override
    public TableSelect.TableJoin<E> withTableLock(boolean lockEnabled) {
        this.tableForLockingSet.add(this.bucket.getTable());
        return this;
    }

    @Override
    public TableSelect.TableJoin<E> allColumns() {
        return this.columns(0, new Range(1, this.bucket.columnSize() - 1).toIntArray());
    }

    @Override
    public TableSelect<E> allColumns(ImmutableTable<E> table) {
        for (ImmutableColumn column : table.columns()) {
            this.column(column);
        }
        return this;
    }

    @Override
    public TableSelect<E> column(ImmutableTable<E> table, int columnIndex) {
        Set<Bucket<E>> bucketSet = this.determineBucketSetFor(table);
        for (Bucket<E> bucket : bucketSet) {
            bucket.addColumnByIndex(columnIndex);
        }
        return this;
    }

    private Set<Bucket<E>> determineBucketSetFor(ImmutableTable<E> table) {
        HashSet<Bucket<Bucket>> bucketSet = new HashSet<Bucket<Bucket>>();
        List bucketList = ListUtils.addToNewList(this.closedBucketList, this.bucket);
        for (Bucket bucket : bucketList) {
            if (!ObjectUtils.equals(table, bucket.getTable())) continue;
            bucketSet.add(bucket);
        }
        return bucketSet;
    }

    @Override
    public TableSelect<E> column(int columnIndex) {
        this.bucket.addColumnByIndex(columnIndex);
        return this;
    }

    @Override
    public TableSelect<E> column(ImmutableColumn<E> column) {
        if (column != null) {
            this.column(column.table(), column.index());
        }
        return this;
    }

    @Override
    public TableSelect.TableJoin<E> columns(int columnIndex, int ... columnIndexes) {
        this.bucket.addColumnByIndex(columnIndex);
        for (int iColumnIndex : columnIndexes) {
            this.bucket.addColumnByIndex(iColumnIndex);
        }
        return this;
    }

    @Override
    public TableSelect.TableJoin<E> join(ImmutableTable<E> table) {
        Assert.isNotNull(table, (String)"table must not be null if joined");
        this.closeAndRolloverBucket(table);
        return this;
    }

    private void closeAndRolloverBucket(ImmutableTable<E> table) {
        this.closedBucketList.add(this.bucket);
        this.bucket = new Bucket<E>(table);
    }

    @Override
    public TableSelect<E> where(TableSelect.Predicate<E> predicate, TableSelect.Predicate<E> ... predicates) {
        if (predicate != null) {
            this.predicateList.add(predicate);
        }
        for (TableSelect.Predicate<E> iPredicate : predicates) {
            if (iPredicate == null) continue;
            this.predicateList.add(iPredicate);
        }
        return this;
    }

    @Override
    public TableSelect.TableSelectExecution<E> as() {
        this.closeAndRolloverBucket(null);
        return this;
    }

    @Override
    public TableSelect.TableJoin<E> onEqual(ImmutableColumn<E> columnLeft, ImmutableColumn<E> columnRight) {
        if (columnLeft != null && columnRight != null) {
            ImmutableColumn.ColumnIdentity<E> columnIdentityLeft = columnLeft.id();
            ImmutableColumn.ColumnIdentity<E> columnIdentityRight = columnRight.id();
            boolean addedToExistingJoin = false;
            ColumnJoin<E> columnJoinResolved = null;
            ArrayList<ColumnJoin<E>> removableColumnJoinList = new ArrayList<ColumnJoin<E>>();
            for (ColumnJoin<E> columnJoin : this.columnJoinList) {
                if (!columnJoin.contains(columnIdentityLeft) && !columnJoin.contains(columnIdentityRight)) continue;
                if (!addedToExistingJoin) {
                    columnJoin.add(columnIdentityRight);
                    columnJoin.add(columnIdentityLeft);
                    addedToExistingJoin = true;
                    columnJoinResolved = columnJoin;
                    continue;
                }
                columnJoinResolved.mergeIntoThis(columnJoin);
                removableColumnJoinList.add(columnJoin);
            }
            if (!addedToExistingJoin) {
                ColumnJoin<E> columnJoin = new ColumnJoin<E>();
                columnJoin.add(columnIdentityRight);
                columnJoin.add(columnIdentityLeft);
                this.columnJoinList.add(columnJoin);
            }
            this.columnJoinList.removeAll(removableColumnJoinList);
        }
        return this;
    }

    @Override
    public TableSelect.TableJoin<E> on(TableSelect.Predicate<E> predicate) {
        if (predicate != null) {
            this.bucket.add(predicate);
        }
        return this;
    }

    @Override
    public Table<E> table() {
        Class componentType = ((Bucket)ListUtils.firstElement(this.closedBucketList)).getTable().elementType();
        ElementHolder rettableElementHolder = new ElementHolder();
        List<Bucket<E>> closedBucketList = this.closedBucketList;
        List<ColumnJoin<E>> columnJoinList = this.columnJoinList;
        SelectExecution tableExecution = new SelectExecution(rettableElementHolder, closedBucketList, componentType, columnJoinList, this.predicateList, this.top, this.skip);
        Set<ImmutableTable<E>> tableForLockingSet = this.tableForLockingSet;
        if (tableForLockingSet.isEmpty()) {
            tableExecution.execute(null);
        } else {
            ImmutableTable table = (ImmutableTable)IterableUtils.firstElement(tableForLockingSet);
            ImmutableTable[] furtherLockedTables = tableForLockingSet.size() > 1 ? (ImmutableTable[])Arrays.copyOfRange(ArrayUtils.valueOf(tableForLockingSet, ImmutableTable.class), 1, tableForLockingSet.size()) : new ImmutableTable[]{};
            table.executeWithReadLock(tableExecution, furtherLockedTables);
        }
        return (Table)rettableElementHolder.getElement();
    }

    @Override
    public SortedMap<E, Set<Row<E>>> sortedMap() {
        TreeMap retmap = new TreeMap();
        Table<E> table = this.table();
        for (Row row : table.rows()) {
            Object key = row.getElement(0);
            LinkedHashSet<Row> set = (LinkedHashSet<Row>)retmap.get(key);
            if (set == null) {
                set = new LinkedHashSet<Row>();
                retmap.put(key, set);
            }
            set.add(row);
        }
        return retmap;
    }

    @Override
    public TableSelect.TableJoin<E> onEqual(ImmutableColumn<E> column, E value) {
        ImmutableColumn.ColumnIdentity<E> columnIdentity = column.id();
        PredicateEqualValue predicate = new PredicateEqualValue(value, columnIdentity);
        return this.on(predicate);
    }

    @Override
    public TableSelect.TableJoin<E> onWithin(ImmutableColumn<E> column, Set<E> valueSet) {
        ImmutableColumn.ColumnIdentity<E> columnIdentity = column.id();
        PredicateWithin predicate = new PredicateWithin(columnIdentity, valueSet);
        return this.on(predicate);
    }

    @Override
    public TableSelect.TableJoin<E> onLike(ImmutableColumn<E> column, Pattern pattern) {
        ImmutableColumn.ColumnIdentity<E> columnIdentity = column.id();
        PredicateLike predicate = new PredicateLike(columnIdentity, pattern);
        return this.on(predicate);
    }

    @Override
    public TableSelect<E> whereEqual(ImmutableColumn<E> column, E value) {
        ImmutableColumn.ColumnIdentity<E> columnIdentity = column.id();
        PredicateEqualValue predicate = new PredicateEqualValue(value, columnIdentity);
        return this.where(predicate);
    }

    @Override
    public TableSelect<E> whereWithin(ImmutableColumn<E> column, Set<E> valueSet) {
        ImmutableColumn.ColumnIdentity<E> columnIdentity = column.id();
        PredicateWithin predicate = new PredicateWithin(columnIdentity, valueSet);
        return this.where(predicate);
    }

    @Override
    public TableSelect<E> whereLike(ImmutableColumn<E> column, Pattern pattern) {
        ImmutableColumn.ColumnIdentity<E> columnIdentity = column.id();
        PredicateLike predicate = new PredicateLike(columnIdentity, pattern);
        return this.where(predicate);
    }

    @Override
    public TableSelect<E> where(TableSelect.Predicate<E> predicate) {
        TableSelect.Predicate[] predicates = new TableSelect.Predicate[]{};
        return this.where(predicate, predicates);
    }

    @Override
    public TableSelect<E> top(int top) {
        this.top = top;
        return this;
    }

    @Override
    public TableSelect<E> skip(int skip) {
        this.skip = skip;
        return this;
    }

    private static class Bucket<E> {
        private final ImmutableTable<E> table;
        private final List<ImmutableColumn<E>> columnList = new ArrayList<ImmutableColumn<E>>();
        private List<TableSelect.Predicate<E>> predicateList = new ArrayList<TableSelect.Predicate<E>>();

        public Bucket(ImmutableTable<E> table) {
            this.table = table;
        }

        public int columnSize() {
            return this.table.columnSize();
        }

        public void addColumnByIndex(int columnIndex) {
            ImmutableColumn<E> column = this.table.column(columnIndex);
            if (column != null) {
                this.columnList.add(column);
            }
        }

        public boolean add(TableSelect.Predicate<E> e) {
            return this.predicateList.add(e);
        }

        public Iterable<FilterRowIdentifiable<E>> newUnfilteredFilterRowIterable() {
            Set<ImmutableColumn.ColumnIdentity<E>> columnIdentitySet = this.determineColumnIdentitySet();
            return IterableUtils.adapter(this.table, (ElementConverter)new ElementConverterRowToFilterRow(columnIdentitySet));
        }

        public Iterable<FilterRowIdentifiable<E>> newFilteredFilterRowIterable(final BitSet filterResult) {
            Set<ImmutableColumn.ColumnIdentity<E>> columnIdentitySet = this.determineColumnIdentitySet();
            final ImmutableTable<E> table = this.table;
            Iterable rowIterable = new Iterable<ImmutableRow<E>>(){

                @Override
                public Iterator<ImmutableRow<E>> iterator() {
                    return new Iterator<ImmutableRow<E>>(){
                        private int index;
                        private boolean resolved;
                        {
                            this.index = filterResult.nextSetBit(0);
                            this.resolved = true;
                        }

                        @Override
                        public boolean hasNext() {
                            if (!this.resolved) {
                                this.index = filterResult.nextSetBit(this.index + 1);
                                this.resolved = true;
                            }
                            return this.index >= 0;
                        }

                        @Override
                        public ImmutableRow<E> next() {
                            if (this.hasNext()) {
                                this.resolved = false;
                                return table.row(this.index);
                            }
                            throw new NoSuchElementException();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
            return IterableUtils.adapter((Iterable)rowIterable, (ElementConverter)new ElementConverterRowToFilterRow(columnIdentitySet));
        }

        private Set<ImmutableColumn.ColumnIdentity<E>> determineColumnIdentitySet() {
            HashSet columnIdentitySet = new HashSet();
            for (ImmutableColumn immutableColumn : this.table.columns()) {
                columnIdentitySet.add(immutableColumn.id());
            }
            return columnIdentitySet;
        }

        public ImmutableTable<E> getTable() {
            return this.table;
        }

        public List<TableSelect.Predicate<E>> getPredicateList() {
            return this.predicateList;
        }

        public List<ImmutableColumn.ColumnIdentity<E>> getSelectedColumnIdentityList() {
            ArrayList<ImmutableColumn.ColumnIdentity<ImmutableColumn.ColumnIdentity<E>>> retlist = new ArrayList<ImmutableColumn.ColumnIdentity<ImmutableColumn.ColumnIdentity<E>>>();
            for (ImmutableColumn<E> immutableColumn : this.columnList) {
                retlist.add(immutableColumn.id());
            }
            return retlist;
        }

        private final class ElementConverterRowToFilterRow
        implements ElementConverter<ImmutableRow<E>, FilterRowIdentifiable<E>> {
            private final Set<ImmutableColumn.ColumnIdentity<E>> columnIdentitySet;

            private ElementConverterRowToFilterRow(Set<ImmutableColumn.ColumnIdentity<E>> columnIdentitySet) {
                this.columnIdentitySet = columnIdentitySet;
            }

            public FilterRowIdentifiable<E> convert(final ImmutableRow<E> immutableRow) {
                final Set columnIdentitySet = this.columnIdentitySet;
                return new FilterRowIdentifiable<E>(){

                    @Override
                    public E getElement(ImmutableColumn.ColumnIdentity<E> columnIdentity) {
                        Object retval = null;
                        if (columnIdentitySet.contains(columnIdentity)) {
                            retval = immutableRow.getElement(columnIdentity.getColumnIndex());
                        }
                        return retval;
                    }

                    @Override
                    public E getElement(ImmutableTable<E> table, int columnIndex) {
                        ImmutableColumn immutableColumn;
                        Object retval = null;
                        if (table != null && (immutableColumn = table.column(columnIndex)) != null) {
                            ImmutableColumn.ColumnIdentity columnIdentity = immutableColumn.id();
                            retval = this.getElement(columnIdentity);
                        }
                        return retval;
                    }

                    @Override
                    public int rowIndex() {
                        return immutableRow.index();
                    }

                    @Override
                    public boolean hasColumn(ImmutableColumn.ColumnIdentity<E> columnIdentity) {
                        return columnIdentitySet.contains(columnIdentity);
                    }

                    @Override
                    public E getElement(ImmutableColumn.ColumnIdentity<E> columnIdentity, int skipNumber) {
                        return this.getElement(columnIdentity);
                    }
                };
            }
        }
    }

    private static class PreparedColumnJoin<E> {
        private final Map<ColumnJoin<E>, Set<E>> columnJoinToIntersectionMap = new HashMap<ColumnJoin<E>, Set<E>>();

        public PreparedColumnJoin(List<ColumnJoin<E>> columnJoinList) {
            for (ColumnJoin<E> columnJoin : columnJoinList) {
                Set<ImmutableColumn.ColumnIdentity<E>> columnIdentitySet = columnJoin.getColumnIdentitySet();
                Set setOfElementSet = SetUtils.convert(columnIdentitySet, (ElementConverter)new ElementConverter<ImmutableColumn.ColumnIdentity<E>, Set<E>>(){

                    public Set<E> convert(ImmutableColumn.ColumnIdentity<E> columnIdentity) {
                        return columnIdentity.column().to().set();
                    }
                });
                Set intersection = SetUtils.intersection((Collection)setOfElementSet);
                this.columnJoinToIntersectionMap.put(columnJoin, intersection);
            }
        }

        private Map<ImmutableColumn.ColumnIdentity<E>, Set<E>> getColumnIdentityToIntersectionMap(ImmutableTable<E> table) {
            HashMap<ImmutableColumn.ColumnIdentity<E>, Set<E>> retmap = new HashMap<ImmutableColumn.ColumnIdentity<E>, Set<E>>();
            for (ColumnJoin<E> columnJoin : this.columnJoinToIntersectionMap.keySet()) {
                Set<ImmutableColumn.ColumnIdentity<E>> columnIdentitySet = columnJoin.getColumnIdentitySet();
                for (ImmutableColumn.ColumnIdentity<E> columnIdentity : columnIdentitySet) {
                    if (!ObjectUtils.equals(table, columnIdentity.getTable())) continue;
                    Set<E> intersection = this.columnJoinToIntersectionMap.get(columnJoin);
                    retmap.put(columnIdentity, intersection);
                }
            }
            return retmap;
        }

        public TableSelect.Predicate<E> newIntersectionPredicate(ImmutableTable<E> table) {
            final Map<ImmutableColumn.ColumnIdentity<E>, Set<E>> columnIdentityToIntersectionMap = this.getColumnIdentityToIntersectionMap(table);
            return new TableSelect.Predicate<E>(){

                @Override
                public boolean isIncluding(TableSelect.Predicate.FilterRow<E> row) {
                    boolean retval = true;
                    for (ImmutableColumn.ColumnIdentity columnIdentity : columnIdentityToIntersectionMap.keySet()) {
                        Object element;
                        Set intersection = (Set)columnIdentityToIntersectionMap.get(columnIdentity);
                        if (intersection.contains(element = row.getElement(columnIdentity))) continue;
                        retval = false;
                        break;
                    }
                    return retval;
                }
            };
        }
    }

    private static class ColumnJoin<E> {
        private final Set<ImmutableColumn.ColumnIdentity<E>> columnIdentitySet = new HashSet<ImmutableColumn.ColumnIdentity<E>>();

        private ColumnJoin() {
        }

        public boolean contains(ImmutableColumn.ColumnIdentity<E> columnIdentity) {
            return this.columnIdentitySet.contains(columnIdentity);
        }

        public boolean add(ImmutableColumn.ColumnIdentity<E> columnIdentity) {
            return this.columnIdentitySet.add(columnIdentity);
        }

        public void mergeIntoThis(ColumnJoin<E> columnJoin) {
            if (columnJoin != null) {
                Set<ImmutableColumn.ColumnIdentity<E>> columnIdentitySet = columnJoin.getColumnIdentitySet();
                this.columnIdentitySet.addAll(columnIdentitySet);
                columnIdentitySet.clear();
            }
        }

        public Set<ImmutableColumn.ColumnIdentity<E>> getColumnIdentitySet() {
            return this.columnIdentitySet;
        }
    }

    private static class CrossProductFilterRowGenerator<E>
    implements Iterable<TableSelect.Predicate.FilterRow<E>> {
        private final Iterable<TableSelect.Predicate.FilterRow<E>> filterRowIterableLeft;
        private final Iterable<TableSelect.Predicate.FilterRow<E>> filterRowIterableRight;
        private final Iterable<ColumnJoin<E>> columnJoinIterable;

        public CrossProductFilterRowGenerator(List<Iterable<? extends TableSelect.Predicate.FilterRow<E>>> filterRowIterableList, Iterable<ColumnJoin<E>> columnJoinIterable) {
            this.columnJoinIterable = columnJoinIterable;
            this.filterRowIterableLeft = (Iterable)ListUtils.firstElement(filterRowIterableList);
            List reducedFilterRowIteratorList = ListUtils.removeFirstToNewList(filterRowIterableList);
            this.filterRowIterableRight = reducedFilterRowIteratorList.size() > 1 ? new CrossProductFilterRowGenerator<E>(reducedFilterRowIteratorList, columnJoinIterable) : (reducedFilterRowIteratorList.size() == 1 ? (Iterable)ListUtils.firstElement((List)reducedFilterRowIteratorList) : null);
        }

        @Override
        public Iterator<TableSelect.Predicate.FilterRow<E>> iterator() {
            if (this.filterRowIterableRight == null) {
                return this.filterRowIterableLeft.iterator();
            }
            final Iterator<TableSelect.Predicate.FilterRow<E>> filterRowLeftIterator = this.filterRowIterableLeft.iterator();
            final IndexBasedFilterRowIterableFactory<E> indexBasedFilterRowIterableFactory = new IndexBasedFilterRowIterableFactory<E>(this.columnJoinIterable, this.filterRowIterableRight);
            final FactoryParameterized filterRowRightIteratorFactory = new FactoryParameterized<Iterator<TableSelect.Predicate.FilterRow<E>>, TableSelect.Predicate.FilterRow<E>>(){

                public Iterator<TableSelect.Predicate.FilterRow<E>> newInstance(TableSelect.Predicate.FilterRow<E> filterRow) {
                    return indexBasedFilterRowIterableFactory.newInstance(filterRow).iterator();
                }
            };
            return new Iterator<TableSelect.Predicate.FilterRow<E>>(){
                private TableSelect.Predicate.FilterRow<E> filterRowRight = null;
                private boolean resolved = false;
                private TableSelect.Predicate.FilterRow<E> filterRowLeft = null;
                private Iterator<TableSelect.Predicate.FilterRow<E>> filterRowRightIterator = null;

                @Override
                public boolean hasNext() {
                    this.resolveNextFilterRowListIfUnresolved();
                    return this.filterRowRight != null && this.filterRowLeft != null;
                }

                private void resolveNextFilterRowListIfUnresolved() {
                    while (!this.resolved) {
                        this.filterRowRight = null;
                        if (this.filterRowRightIterator != null && !this.filterRowRightIterator.hasNext()) {
                            this.filterRowLeft = null;
                            this.filterRowRightIterator = null;
                        }
                        if (this.filterRowLeft == null && filterRowLeftIterator.hasNext()) {
                            this.filterRowLeft = (TableSelect.Predicate.FilterRow)filterRowLeftIterator.next();
                        }
                        if (this.filterRowRightIterator == null) {
                            this.filterRowRightIterator = (Iterator)filterRowRightIteratorFactory.newInstance(this.filterRowLeft);
                        }
                        if (this.filterRowRightIterator != null && this.filterRowRightIterator.hasNext()) {
                            this.filterRowRight = this.filterRowRightIterator.next();
                        } else if (filterRowLeftIterator.hasNext()) continue;
                        this.resolved = true;
                    }
                }

                @Override
                public TableSelect.Predicate.FilterRow<E> next() {
                    if (this.hasNext()) {
                        this.resolved = false;
                        return new FilterRowComposite(Arrays.asList(this.filterRowLeft, this.filterRowRight));
                    }
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class FilterRowComposite<E>
    extends FilterRowAbstract<E> {
        private final List<TableSelect.Predicate.FilterRow<E>> filterRowList;

        public FilterRowComposite(List<TableSelect.Predicate.FilterRow<E>> filterRowList) {
            this.filterRowList = filterRowList;
        }

        @Override
        public E getElement(ImmutableColumn.ColumnIdentity<E> columnIdentity) {
            boolean skipNumber = false;
            return this.getElement(columnIdentity, 0);
        }

        @Override
        public boolean hasColumn(ImmutableColumn.ColumnIdentity<E> columnIdentity) {
            for (TableSelect.Predicate.FilterRow<E> filterRow : this.filterRowList) {
                boolean hasColumn = filterRow.hasColumn(columnIdentity);
                if (!hasColumn) continue;
                return true;
            }
            return false;
        }

        @Override
        public E getElement(ImmutableColumn.ColumnIdentity<E> columnIdentity, int skipNumber) {
            E retval = null;
            int matchCounter = 0;
            for (TableSelect.Predicate.FilterRow<E> filterRow : this.filterRowList) {
                if (!filterRow.hasColumn(columnIdentity)) continue;
                if (skipNumber == matchCounter) {
                    E element = filterRow.getElement(columnIdentity);
                    retval = element;
                    break;
                }
                ++matchCounter;
            }
            return retval;
        }
    }

    private static abstract class FilterRowAbstract<E>
    implements TableSelect.Predicate.FilterRow<E> {
        private FilterRowAbstract() {
        }

        @Override
        public E getElement(ImmutableTable<E> table, int columnIndex) {
            ImmutableColumn<E> immutableColumn;
            E retval = null;
            if (table != null && (immutableColumn = table.column(columnIndex)) != null) {
                ImmutableColumn.ColumnIdentity<E> columnIdentity = immutableColumn.id();
                retval = this.getElement(columnIdentity);
            }
            return retval;
        }
    }

    public static class FilterRowFilterer<E> {
        private final Iterable<FilterRowIdentifiable<E>> filterRowIterable;
        private final Iterable<TableSelect.Predicate<E>> predicateIterable;

        public FilterRowFilterer(Iterable<FilterRowIdentifiable<E>> filterRowIterable, Iterable<TableSelect.Predicate<E>> predicateIterable) {
            this.filterRowIterable = filterRowIterable;
            this.predicateIterable = predicateIterable;
        }

        public BitSet calculateFilterResult() {
            BitSet retval = new BitSet();
            for (FilterRowIdentifiable<E> filterRow : this.filterRowIterable) {
                int rowIndex = filterRow.rowIndex();
                boolean including = true;
                for (TableSelect.Predicate<E> predicate : this.predicateIterable) {
                    if (predicate.isIncluding(filterRow)) continue;
                    including = false;
                    break;
                }
                if (!including) continue;
                retval.set(rowIndex);
            }
            return retval;
        }
    }

    private static interface FilterRowIdentifiable<E>
    extends TableSelect.Predicate.FilterRow<E> {
        public int rowIndex();
    }

    private static final class SelectExecution<E>
    implements TableExecution<ImmutableTable<E>, E> {
        private final ElementHolder<Table<E>> rettableElementHolder;
        private final List<Bucket<E>> closedBucketList;
        private final Class<E> componentType;
        private final List<ColumnJoin<E>> columnJoinList;
        private final List<TableSelect.Predicate<E>> predicateList;
        private final int top;
        private final int skip;

        private SelectExecution(ElementHolder<Table<E>> rettableElementHolder, List<Bucket<E>> closedBucketList, Class<E> componentType, List<ColumnJoin<E>> columnJoinList, List<TableSelect.Predicate<E>> predicateList, int top, int skip) {
            this.rettableElementHolder = rettableElementHolder;
            this.closedBucketList = closedBucketList;
            this.componentType = componentType;
            this.columnJoinList = columnJoinList;
            this.predicateList = predicateList;
            this.top = top;
            this.skip = skip;
        }

        @Override
        public void execute(ImmutableTable<E> table) {
            ArrayList<ImmutableColumn.ColumnIdentity<E>> selectedColumnIdentityList = new ArrayList<ImmutableColumn.ColumnIdentity<E>>();
            ArrayList<Iterable<TableSelect.Predicate.FilterRow<Iterable<FilterRowIdentifiable<E>>>>> filteredFilterRowIterableList = new ArrayList<Iterable<TableSelect.Predicate.FilterRow<Iterable<FilterRowIdentifiable<E>>>>>();
            PreparedColumnJoin<E> preparedColumnJoin = new PreparedColumnJoin<E>(this.columnJoinList);
            for (Bucket<E> bucket : this.closedBucketList) {
                Iterable<FilterRowIdentifiable<E>> filterRowIterable = bucket.newUnfilteredFilterRowIterable();
                TableSelect.Predicate<E> predicate = preparedColumnJoin.newIntersectionPredicate(bucket.getTable());
                FilterRowFilterer<E> filterRowFilterer = new FilterRowFilterer<E>(filterRowIterable, ListUtils.add(bucket.getPredicateList(), predicate));
                BitSet filterResult = filterRowFilterer.calculateFilterResult();
                Iterable<FilterRowIdentifiable<E>> filteredFilterRowIterable = bucket.newFilteredFilterRowIterable(filterResult);
                filteredFilterRowIterableList.add(filteredFilterRowIterable);
                selectedColumnIdentityList.addAll(bucket.getSelectedColumnIdentityList());
            }
            CrossProductFilterRowGenerator<E> crossProductFilterRowGenerator = new CrossProductFilterRowGenerator<E>(filteredFilterRowIterableList, this.columnJoinList);
            ArrayList<Object[]> elementArrayList = new ArrayList<Object[]>();
            int resultRowStart = this.skip;
            int resultRowEnd = this.top >= 0 ? this.top + this.skip - 1 : -1;
            int columnSize = 0;
            int rowCounter = 0;
            for (TableSelect.Predicate.FilterRow<E> filterRow : crossProductFilterRowGenerator) {
                boolean include = true;
                block2: for (ColumnJoin<E> columnJoin : this.columnJoinList) {
                    Set<ImmutableColumn.ColumnIdentity<E>> set = columnJoin.getColumnIdentitySet();
                    if (set.size() <= 1) continue;
                    Iterator<ImmutableColumn.ColumnIdentity<E>> iterator = set.iterator();
                    ImmutableColumn.ColumnIdentity<E> columnIdentityFirst = iterator.next();
                    E compareElement = filterRow.getElement(columnIdentityFirst);
                    while (iterator.hasNext()) {
                        ImmutableColumn.ColumnIdentity<E> columnIdentity = iterator.next();
                        E element = filterRow.getElement(columnIdentity);
                        if (ObjectUtils.equals(compareElement, element)) continue;
                        include = false;
                        break block2;
                    }
                }
                if (this.predicateList != null) {
                    TableSelect.Predicate predicate;
                    Iterator<Object> i$ = this.predicateList.iterator();
                    while (i$.hasNext() && (include &= (predicate = (TableSelect.Predicate)i$.next()).isIncluding(filterRow))) {
                    }
                }
                if (!include) continue;
                if (rowCounter >= resultRowStart && (resultRowEnd < 0 || rowCounter <= resultRowEnd)) {
                    ArrayList<E> elementList = new ArrayList<E>();
                    Map columnIdentityToCounterMap = MapUtils.initializedCounterMap();
                    for (ImmutableColumn.ColumnIdentity columnIdentity : selectedColumnIdentityList) {
                        int counter = ((AtomicInteger)columnIdentityToCounterMap.get(columnIdentity)).getAndIncrement();
                        E element = filterRow.getElement(columnIdentity, counter);
                        elementList.add(element);
                    }
                    elementArrayList.add(elementList.toArray((Object[])Array.newInstance(this.componentType, elementList.size())));
                    columnSize = elementArrayList.size();
                }
                ++rowCounter;
            }
            Object[][] elementMatrix = (Object[][])elementArrayList.toArray((T[])((Object[][])Array.newInstance(this.componentType, elementArrayList.size(), columnSize)));
            ArrayTable<Object> rettable = new ArrayTable<Object>(elementMatrix);
            LinkedHashSet<String> tableNameSet = new LinkedHashSet<String>();
            int columnIndex = 0;
            for (ImmutableColumn.ColumnIdentity columnIdentity : selectedColumnIdentityList) {
                ImmutableColumn immutableColumn = columnIdentity.column();
                String tableName = immutableColumn.table().getTableName();
                String columnTitle = tableName + "." + immutableColumn.getTitle();
                rettable.setColumnTitle(columnIndex++, columnTitle);
                tableNameSet.add(tableName);
            }
            rettable.setTableName(CollectionUtils.toString(tableNameSet, (ElementConverter)new ElementConverterIdentity(), (Joiner)Joiner.on((String)" ")));
            this.rettableElementHolder.setElement(rettable);
        }
    }

    private static class IndexBasedFilterRowIterableFactory<E>
    implements FactoryParameterized<Iterable<TableSelect.Predicate.FilterRow<E>>, TableSelect.Predicate.FilterRow<E>> {
        private final List<ColumnJoinIndex<E>> columnJoinIndexList = new ArrayList<ColumnJoinIndex<E>>();
        private final Set<TableSelect.Predicate.FilterRow<E>> filterRowSet;

        public IndexBasedFilterRowIterableFactory(Iterable<ColumnJoin<E>> columnJoinIterable, Iterable<TableSelect.Predicate.FilterRow<E>> filterRowIterable) {
            this.filterRowSet = SetUtils.valueOf(filterRowIterable);
            for (ColumnJoin<E> columnJoin : columnJoinIterable) {
                this.columnJoinIndexList.add(new ColumnJoinIndex<E>(columnJoin, this.filterRowSet));
            }
        }

        public Iterable<TableSelect.Predicate.FilterRow<E>> newInstance(final TableSelect.Predicate.FilterRow<E> filterRow) {
            if (!this.columnJoinIndexList.isEmpty()) {
                List filterRowSetList = ListUtils.convert(this.columnJoinIndexList, (ElementConverter)new ElementConverter<ColumnJoinIndex<E>, Set<TableSelect.Predicate.FilterRow<E>>>(){

                    public Set<TableSelect.Predicate.FilterRow<E>> convert(ColumnJoinIndex<E> columnJoinIndex) {
                        return columnJoinIndex.indexFilteredFilterRowSet(filterRow);
                    }
                });
                Set intersection = SetUtils.intersection((Collection)filterRowSetList);
                return intersection;
            }
            return this.filterRowSet;
        }
    }

    private static class ColumnJoinIndex<E> {
        private final ColumnJoin<E> columnJoin;
        private final Map<E, Set<TableSelect.Predicate.FilterRow<E>>> elementToFilterRowSetMap = new HashMap<E, Set<TableSelect.Predicate.FilterRow<E>>>();
        private final IndexElementCalculator<E> indexElementCalculator;
        private final Set<TableSelect.Predicate.FilterRow<E>> filterRowSet;
        private final boolean noIndexAvailable;

        public ColumnJoinIndex(ColumnJoin<E> columnJoin, Set<TableSelect.Predicate.FilterRow<E>> filterRowSet) {
            this.columnJoin = columnJoin;
            this.filterRowSet = filterRowSet;
            this.indexElementCalculator = new IndexElementCalculator<E>(this.columnJoin);
            this.noIndexAvailable = this.prepareIndex(filterRowSet);
        }

        private boolean prepareIndex(Iterable<TableSelect.Predicate.FilterRow<E>> filterRowIterable) {
            Map elementToFilterRowSetMapInitialized = MapUtils.initializedMap(this.elementToFilterRowSetMap, (Factory)new LinkedHashSetFactory());
            for (TableSelect.Predicate.FilterRow<E> filterRow : filterRowIterable) {
                MatchElement<E> matchElement = this.indexElementCalculator.calculate(filterRow);
                boolean hasMatchingColumn = matchElement.hasMatchingColumn();
                if (!hasMatchingColumn) {
                    return true;
                }
                boolean hasElement = matchElement.hasElement();
                if (!hasElement) continue;
                E element = matchElement.getElement();
                ((Set)elementToFilterRowSetMapInitialized.get(element)).add(filterRow);
            }
            return false;
        }

        public Set<TableSelect.Predicate.FilterRow<E>> indexFilteredFilterRowSet(TableSelect.Predicate.FilterRow<E> filterRow) {
            Set<TableSelect.Predicate.FilterRow<TableSelect.Predicate.FilterRow<TableSelect.Predicate.FilterRow<TableSelect.Predicate.FilterRow<E>>>>> filterRowSet;
            MatchElement<E> matchElement;
            Set<TableSelect.Predicate.FilterRow<TableSelect.Predicate.FilterRow<Object>>> retval = null;
            retval = this.noIndexAvailable ? this.filterRowSet : (!(matchElement = this.indexElementCalculator.calculate(filterRow)).hasMatchingColumn() ? this.filterRowSet : (!matchElement.hasElement() ? SetUtils.emptySet() : (filterRowSet = this.elementToFilterRowSetMap.get(matchElement.getElement()))));
            return retval;
        }
    }

    private static class IndexElementCalculator<E> {
        private final ColumnJoin<E> columnJoin;

        public IndexElementCalculator(ColumnJoin<E> columnJoin) {
            this.columnJoin = columnJoin;
        }

        public MatchElement<E> calculate(TableSelect.Predicate.FilterRow<E> filterRow) {
            Object element;
            MatchElement<Object> retval = null;
            HashSet<E> elementSet = new HashSet<E>();
            if (filterRow != null) {
                Set<ImmutableColumn.ColumnIdentity<E>> columnIdentitySet = this.columnJoin.getColumnIdentitySet();
                for (ImmutableColumn.ColumnIdentity<E> columnIdentity : columnIdentitySet) {
                    if (!filterRow.hasColumn(columnIdentity)) continue;
                    E element2 = filterRow.getElement(columnIdentity);
                    elementSet.add(element2);
                }
            }
            if (elementSet.size() == 1) {
                Object element3 = IterableUtils.firstElement(elementSet);
                boolean hasElement = true;
                boolean hasMatchingColumn = true;
                retval = new MatchElement<Object>(element3, true, true);
            } else if (elementSet.size() == 0) {
                boolean hasMatchingColumn = false;
                boolean hasElement = false;
                element = null;
                retval = new MatchElement<Object>(element, false, false);
            } else {
                boolean hasMatchingColumn = true;
                boolean hasElement = false;
                element = null;
                retval = new MatchElement<Object>(element, false, true);
            }
            return retval;
        }
    }

    private static class MatchElement<E> {
        private final E element;
        private final boolean hasElement;
        private final boolean hasMatchingColumn;

        public MatchElement(E element, boolean hasElement, boolean hasMatchingColumn) {
            this.element = element;
            this.hasElement = hasElement;
            this.hasMatchingColumn = hasMatchingColumn;
        }

        public boolean hasElement() {
            return this.hasElement;
        }

        public E getElement() {
            return this.element;
        }

        public boolean hasMatchingColumn() {
            return this.hasMatchingColumn;
        }
    }

    private static final class PredicateLike<E>
    implements TableSelect.Predicate<E> {
        private final ImmutableColumn.ColumnIdentity<E> columnIdentity;
        private final Pattern pattern;

        private PredicateLike(ImmutableColumn.ColumnIdentity<E> columnIdentity, Pattern pattern) {
            this.columnIdentity = columnIdentity;
            this.pattern = pattern;
        }

        @Override
        public boolean isIncluding(TableSelect.Predicate.FilterRow<E> row) {
            E element = row.getElement(this.columnIdentity);
            String value = element != null ? String.valueOf(element) : null;
            boolean retval = this.pattern != null && value != null && this.pattern.matcher(value).matches();
            return retval;
        }
    }

    private static final class PredicateWithin<E>
    implements TableSelect.Predicate<E> {
        private final ImmutableColumn.ColumnIdentity<E> columnIdentity;
        private final Set<E> valueSet;

        private PredicateWithin(ImmutableColumn.ColumnIdentity<E> columnIdentity, Set<E> valueSet) {
            this.columnIdentity = columnIdentity;
            this.valueSet = valueSet;
        }

        @Override
        public boolean isIncluding(TableSelect.Predicate.FilterRow<E> row) {
            E element = row.getElement(this.columnIdentity);
            return this.valueSet != null && this.valueSet.contains(element);
        }
    }

    private static final class PredicateEqualValue<E>
    implements TableSelect.Predicate<E> {
        private final E value;
        private final ImmutableColumn.ColumnIdentity<E> columnIdentity;

        private PredicateEqualValue(E value, ImmutableColumn.ColumnIdentity<E> columnIdentity) {
            this.value = value;
            this.columnIdentity = columnIdentity;
        }

        @Override
        public boolean isIncluding(TableSelect.Predicate.FilterRow<E> row) {
            E element = row.getElement(this.columnIdentity);
            return ObjectUtils.equals(this.value, element);
        }
    }
}

