/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.persistence;

import java.util.List;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.table.TablePersistence;
import org.omnaest.utils.tuple.KeyValue;

abstract class SimpleDirectoryBasedTablePersistenceAbstract<E>
implements TablePersistence<E> {
    private static final long serialVersionUID = 3838780633578772811L;
    protected final List<E[]> elementsList;

    public SimpleDirectoryBasedTablePersistenceAbstract(List<E[]> elementsList) {
        this.elementsList = elementsList;
    }

    @Override
    public void add(int id, E[] elements) {
        this.elementsList.add(id, elements);
    }

    @Override
    public Iterable<KeyValue<Integer, E[]>> allElements() {
        return ListUtils.convert(this.elementsList, (ElementConverter)new ElementConverter<E[], KeyValue<Integer, E[]>>(){
            private int index = 0;

            public KeyValue<Integer, E[]> convert(E[] elements) {
                Integer key = this.index++;
                E[] value = elements;
                return new KeyValue((Object)key, value);
            }
        });
    }

    @Override
    public void remove(int id) {
        this.elementsList.remove(id);
    }

    @Override
    public void removeAll() {
        this.elementsList.clear();
    }

    @Override
    public void update(int id, E[] elements) {
        this.elementsList.set(id, elements);
    }

    @Override
    public void setTableName(String tableName) {
    }

    @Override
    public void setColumnTitles(String[] columnTitles) {
    }
}

