/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.persistence;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.omnaest.utils.events.exception.ExceptionHandlerSerializable;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.table.TablePersistence;
import org.omnaest.utils.tuple.KeyValue;

public class SimpleFileBasedTablePersistence<E>
implements TablePersistence<E> {
    private static final long serialVersionUID = 4587018898135825772L;
    private List<E[]> elementsList;
    private final ExceptionHandlerSerializable exceptionHandler;
    private final File file;

    public SimpleFileBasedTablePersistence(File file, ExceptionHandlerSerializable exceptionHandler) {
        block4: {
            this.elementsList = new ArrayList<E[]>();
            this.file = file;
            this.exceptionHandler = exceptionHandler;
            if (file != null && file.exists()) {
                try {
                    byte[] byteArray = FileUtils.readFileToByteArray((File)file);
                    List deserializedList = (List)SerializationUtils.deserialize((byte[])byteArray);
                    if (deserializedList != null) {
                        this.elementsList.addAll(deserializedList);
                    }
                }
                catch (Exception e) {
                    if (this.exceptionHandler == null) break block4;
                    this.exceptionHandler.handleException(e);
                }
            }
        }
    }

    @Override
    public void add(int id, E[] elements) {
        this.elementsList.add(id, elements);
        this.writeToFile();
    }

    @Override
    public Iterable<KeyValue<Integer, E[]>> allElements() {
        return ListUtils.convert(this.elementsList, (ElementConverter)new ElementConverter<E[], KeyValue<Integer, E[]>>(){
            private int index = 0;

            public KeyValue<Integer, E[]> convert(E[] elements) {
                Integer key = this.index++;
                E[] value = elements;
                return new KeyValue((Object)key, value);
            }
        });
    }

    @Override
    public void remove(int id) {
        this.elementsList.remove(id);
        this.writeToFile();
    }

    @Override
    public void removeAll() {
        this.elementsList.clear();
        this.writeToFile();
    }

    @Override
    public void update(int id, E[] elements) {
        this.elementsList.set(id, elements);
        this.writeToFile();
    }

    private void writeToFile() {
        block3: {
            if (this.file != null) {
                try {
                    byte[] data = SerializationUtils.serialize((Serializable)((Serializable)((Object)this.elementsList)));
                    FileUtils.writeByteArrayToFile((File)this.file, (byte[])data);
                }
                catch (Exception e) {
                    if (this.exceptionHandler == null) break block3;
                    this.exceptionHandler.handleException(e);
                }
            }
        }
    }

    @Override
    public void setTableName(String tableName) {
    }

    @Override
    public void setColumnTitles(String[] columnTitles) {
    }
}

