/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.rowdata;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.beans.BeanUtils;
import org.omnaest.utils.beans.result.BeanMethodInformation;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.proxy.StubCreator;
import org.omnaest.utils.proxy.handler.MethodCallCapture;
import org.omnaest.utils.proxy.handler.MethodInvocationHandler;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.RowDataAccessor;
import org.omnaest.utils.table.RowDataReader;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.impl.rowdata.ElementsToRowDataReaderAdapter;
import org.omnaest.utils.table.impl.rowdata.RowToRowDataAccessorAdapter;

public class RowDataBasedBeanFactory<B> {
    private final StubCreator<B> stubCreator;
    private final Map<Method, String> getterMethodToPropertyNameMap;
    private final Map<Method, String> setterMethodToPropertyNameMap;
    private final ExceptionHandler exceptionHandler;

    public RowDataBasedBeanFactory(Class<B> beanType, ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        this.getterMethodToPropertyNameMap = new HashMap<Method, String>();
        this.setterMethodToPropertyNameMap = new HashMap<Method, String>();
        Set beanMethodInformationSet = BeanUtils.beanMethodInformationSet(beanType);
        for (BeanMethodInformation beanMethodInformation : beanMethodInformationSet) {
            boolean isGetter = beanMethodInformation.isGetter();
            boolean isSetter = beanMethodInformation.isSetter();
            Method method = beanMethodInformation.getMethod();
            String propertyName = beanMethodInformation.getPropertyName();
            if (isGetter) {
                this.getterMethodToPropertyNameMap.put(method, propertyName);
                continue;
            }
            if (!isSetter) continue;
            this.setterMethodToPropertyNameMap.put(method, propertyName);
        }
        this.stubCreator = new StubCreator(beanType, exceptionHandler);
    }

    public <E> B build(RowDataAccessor<E> rowDataAccessor) {
        RowAccessInvocationHandler<E> methodInvocationHandler = new RowAccessInvocationHandler<E>(this.exceptionHandler, this.getterMethodToPropertyNameMap, this.setterMethodToPropertyNameMap, rowDataAccessor);
        Object bean = this.stubCreator.build(methodInvocationHandler);
        return (B)bean;
    }

    public <E> B build(Table<E> table, E[] elements) {
        return this.build(new ElementsToRowDataReaderAdapter<E>(elements, table));
    }

    public <E> B build(final RowDataReader<E> rowDataReader) {
        return this.build(new RowDataAccessor<E>(){

            @Override
            public E getElement(String columnTitle) {
                return rowDataReader.getElement(columnTitle);
            }

            @Override
            public E getElement(int columnIndex) {
                return rowDataReader.getElement(columnIndex);
            }

            @Override
            public E[] getElements() {
                return rowDataReader.getElements();
            }

            @Override
            public void setElement(String columnTitle, E element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setElement(int columnIndex, E element) {
                throw new UnsupportedOperationException();
            }
        });
    }

    public <E> B build(Row<E> row) {
        return this.build(new RowToRowDataAccessorAdapter<E>(row));
    }

    private static final class RowAccessInvocationHandler<E>
    implements MethodInvocationHandler {
        private final ExceptionHandler exceptionHandler;
        private final Map<Method, String> getterMethodToPropertyNameMap;
        private final Map<Method, String> setterMethodToPropertyNameMap;
        private final RowDataAccessor<E> rowDataAccessor;

        RowAccessInvocationHandler(ExceptionHandler exceptionHandler, Map<Method, String> getterMethodToPropertyNameMap, Map<Method, String> setterMethodToPropertyNameMap, RowDataAccessor<E> rowDataAccessor) {
            this.exceptionHandler = exceptionHandler;
            this.getterMethodToPropertyNameMap = getterMethodToPropertyNameMap;
            this.setterMethodToPropertyNameMap = setterMethodToPropertyNameMap;
            this.rowDataAccessor = rowDataAccessor;
        }

        public Object handle(MethodCallCapture methodCallCapture) throws Throwable {
            String retval = null;
            try {
                Method method = methodCallCapture.getMethod();
                String methodName = method.getName();
                if (this.getterMethodToPropertyNameMap.containsKey(method)) {
                    String propertyName = this.getterMethodToPropertyNameMap.get(method);
                    Object element = this.rowDataAccessor.getElement(propertyName);
                    retval = (String)element;
                } else if (this.setterMethodToPropertyNameMap.containsKey(method)) {
                    String propertyName = this.setterMethodToPropertyNameMap.get(method);
                    Object element = methodCallCapture.getArgumentCasted(0);
                    this.rowDataAccessor.setElement(propertyName, element);
                } else if (StringUtils.equals((CharSequence)"toString", (CharSequence)methodName)) {
                    retval = Arrays.deepToString(this.rowDataAccessor.getElements());
                }
            }
            catch (Exception e) {
                this.exceptionHandler.handleException(e);
            }
            return retval;
        }
    }
}

