/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.serializer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.table.Cell;
import org.omnaest.utils.table.ImmutableTableSerializer;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.impl.serializer.MarshallerAbstract;

class CsvMarshallerImpl<E>
extends MarshallerAbstract<E>
implements ImmutableTableSerializer.MarshallerCsv<E> {
    private ImmutableTableSerializer.MarshallerCsv.CSVMarshallingConfiguration configuration = new ImmutableTableSerializer.MarshallerCsv.CSVMarshallingConfiguration();

    public CsvMarshallerImpl(Table<E> table, ExceptionHandler exceptionHandler) {
        super(table, exceptionHandler);
    }

    @Override
    public Table<E> to(Appendable appendable) {
        try {
            if (appendable != null) {
                boolean processTableName;
                boolean hasColumnTitles = this.table.hasColumnTitles();
                boolean hasRowTitles = this.table.hasRowTitles();
                boolean hasTableName = this.table.hasTableName();
                boolean processColumnTitles = this.configuration.hasEnabledColumnTitles() && hasColumnTitles;
                boolean processRowTitles = this.configuration.hasEnabledRowTitles() && hasRowTitles;
                boolean bl = processTableName = this.configuration.hasEnabledTableName() && hasTableName;
                if (processTableName) {
                    appendable.append(String.valueOf(this.table.getTableName()) + "\n");
                }
                if (processColumnTitles) {
                    if (processRowTitles) {
                        appendable.append(this.configuration.getDelimiter());
                    }
                    boolean first = true;
                    for (String columnTitleValue : this.table.getColumnTitleList()) {
                        appendable.append(!first ? this.configuration.getDelimiter() : "");
                        appendable.append(String.valueOf(columnTitleValue));
                        first = false;
                    }
                    appendable.append("\n");
                }
                for (Row row : this.table.rows()) {
                    if (processRowTitles) {
                        appendable.append(row.getTitle());
                        appendable.append(this.configuration.getDelimiter());
                    }
                    boolean first = true;
                    for (Cell cell : row.cells()) {
                        appendable.append(!first ? this.configuration.getDelimiter() : "");
                        Object element = cell.getElement();
                        appendable.append(this.encodeIntoCellString(element));
                        first = false;
                    }
                    appendable.append("\n");
                }
            }
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
        }
        return this.table;
    }

    private String encodeIntoCellString(E element) {
        String retval = null;
        if (element != null) {
            boolean containsQuotationCharacter;
            retval = String.valueOf(element);
            boolean containsDelimiter = retval.contains(this.configuration.getDelimiter());
            boolean bl = containsQuotationCharacter = StringUtils.isNotEmpty((CharSequence)this.configuration.getQuotationCharacter()) && retval.contains(this.configuration.getQuotationCharacter());
            if (containsQuotationCharacter) {
                retval = retval.replaceAll(Pattern.quote(this.configuration.getQuotationCharacter()), Matcher.quoteReplacement(this.configuration.getQuotationCharacter() + this.configuration.getQuotationCharacter()));
            }
            if (containsDelimiter) {
                retval = this.configuration.getQuotationCharacter() + retval + this.configuration.getQuotationCharacter();
            }
        }
        return retval;
    }

    @Override
    public ImmutableTableSerializer.MarshallerCsv<E> using(ImmutableTableSerializer.MarshallerCsv.CSVMarshallingConfiguration configuration) {
        this.configuration = (ImmutableTableSerializer.MarshallerCsv.CSVMarshallingConfiguration)ObjectUtils.defaultIfNull((Object)configuration, (Object)new ImmutableTableSerializer.MarshallerCsv.CSVMarshallingConfiguration());
        return this;
    }

    @Override
    protected String getEncoding() {
        return this.configuration.getEncoding();
    }
}

