/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.serializer;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.table.ImmutableTableSerializer;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableSerializer;
import org.omnaest.utils.table.impl.serializer.UnmarshallerAbstract;

class CsvUnmarshallerImpl<E>
extends UnmarshallerAbstract<E>
implements TableSerializer.UnmarshallerCsv<E> {
    private ImmutableTableSerializer.MarshallerCsv.CSVMarshallingConfiguration configuration = new ImmutableTableSerializer.MarshallerCsv.CSVMarshallingConfiguration();

    public CsvUnmarshallerImpl(Table<E> table, ExceptionHandler exceptionHandler) {
        super(table, exceptionHandler);
    }

    @Override
    public Table<E> from(Reader reader) {
        if (reader != null) {
            String line;
            this.table.clear();
            Scanner scanner = new Scanner(reader);
            if (this.configuration.hasEnabledTableName()) {
                String tableName;
                String string = tableName = scanner.hasNextLine() ? scanner.nextLine() : null;
                if (tableName != null) {
                    this.table.setTableName(tableName);
                }
            }
            if (this.configuration.hasEnabledColumnTitles()) {
                String columnLine;
                String string = columnLine = scanner.hasNextLine() ? scanner.nextLine() : null;
                if (columnLine != null) {
                    Object[] columnTokens = this.extractCellTokensFromLine(columnLine);
                    if (this.configuration.hasEnabledRowTitles()) {
                        columnTokens = (String[])ArrayUtils.remove((Object[])columnTokens, (int)0);
                    }
                    this.table.setColumnTitles(Arrays.asList(columnTokens));
                }
            }
            int rowIndexPosition = 0;
            String string = line = scanner.hasNextLine() ? scanner.nextLine() : null;
            while (line != null) {
                Object[] cellTokens = this.extractCellTokensFromLine(line);
                if (this.configuration.hasEnabledRowTitles() && cellTokens.length > 0) {
                    String rowTitleValue = cellTokens[0];
                    this.table.setRowTitle(rowIndexPosition, rowTitleValue);
                    cellTokens = (String[])ArrayUtils.remove((Object[])cellTokens, (int)0);
                }
                for (int columnIndexPosition = 0; columnIndexPosition < cellTokens.length; ++columnIndexPosition) {
                    try {
                        String elementString = cellTokens[columnIndexPosition];
                        Class elementType = this.table.elementType();
                        Object element = ObjectUtils.castTo(elementType, (Object)elementString);
                        this.table.setElement(rowIndexPosition, columnIndexPosition, element);
                        continue;
                    }
                    catch (Exception e) {
                        this.exceptionHandler.handleException(e);
                    }
                }
                line = scanner.hasNextLine() ? scanner.nextLine() : null;
                ++rowIndexPosition;
            }
        }
        return this.table;
    }

    private String[] extractCellTokensFromLine(String line) {
        String[] retvals = null;
        if (line != null) {
            if (StringUtils.isNotEmpty((CharSequence)this.configuration.getQuotationCharacter())) {
                ArrayList<String> retlist = new ArrayList<String>();
                QuotationTextParser quotationTextParser = new QuotationTextParser(line, this.configuration.getDelimiter(), this.configuration.getQuotationCharacter());
                String next = null;
                while ((next = quotationTextParser.next()) != null) {
                    retlist.add(next);
                }
                retvals = retlist.toArray(new String[retlist.size()]);
            } else {
                retvals = StringUtils.splitPreserveAllTokens((String)line, (String)this.configuration.getDelimiter());
            }
        }
        return retvals;
    }

    @Override
    public TableSerializer.UnmarshallerCsv<E> using(ImmutableTableSerializer.MarshallerCsv.CSVMarshallingConfiguration configuration) {
        this.configuration = (ImmutableTableSerializer.MarshallerCsv.CSVMarshallingConfiguration)ObjectUtils.defaultIfNull((Object)configuration, (Object)new ImmutableTableSerializer.MarshallerCsv.CSVMarshallingConfiguration());
        return this;
    }

    @Override
    protected String getEncoding() {
        return this.configuration.getEncoding();
    }

    public static class QuotationTextParser {
        private final char[] delimiter;
        private final char[] quotationCharacter;
        private int offset = 0;
        private final char[] characters;

        public QuotationTextParser(String text, String delimiter, String quotationCharacter) {
            this.delimiter = delimiter.toCharArray();
            this.quotationCharacter = quotationCharacter.toCharArray();
            this.characters = text.toCharArray();
        }

        public String next() {
            StringBuilder retval = null;
            boolean hasUnreadCharacters = this.determineHasUnreadCharacters();
            if (hasUnreadCharacters) {
                retval = new StringBuilder();
                int quotationCharacterLength = this.quotationCharacter.length;
                int delimiterCharacterLength = this.delimiter.length;
                boolean isWithinQuote = false;
                while (this.determineHasUnreadCharacters()) {
                    char[] nextCharsForQuotationMatching = this.determineNextChars(quotationCharacterLength);
                    if (nextCharsForQuotationMatching != null && Arrays.equals(this.quotationCharacter, nextCharsForQuotationMatching)) {
                        char[] nextCharsForDoubleQuotationMatching = this.determineNextChars(quotationCharacterLength, quotationCharacterLength);
                        if (Arrays.equals(this.quotationCharacter, nextCharsForDoubleQuotationMatching)) {
                            retval.append(this.quotationCharacter);
                            this.forwardOffset(quotationCharacterLength * 2);
                            continue;
                        }
                        isWithinQuote = !isWithinQuote;
                        this.forwardOffset(quotationCharacterLength);
                        continue;
                    }
                    char[] nextCharsForDelimiterMatching = this.determineNextChars(delimiterCharacterLength);
                    if (!isWithinQuote && Arrays.equals(this.delimiter, nextCharsForDelimiterMatching)) {
                        this.forwardOffset(delimiterCharacterLength);
                        break;
                    }
                    char[] nextChar = this.determineNextChars(1);
                    this.forwardOffset(1);
                    retval.append(nextChar);
                }
            }
            return retval != null ? retval.toString() : null;
        }

        private boolean determineHasUnreadCharacters() {
            return this.offset < this.characters.length;
        }

        private void forwardOffset(int length) {
            this.offset += length;
        }

        private char[] determineNextChars(int length) {
            boolean additionalOffsetDelta = false;
            return this.determineNextChars(0, length);
        }

        private char[] determineNextChars(int additionalOffsetDelta, int length) {
            char[] retval = null;
            int startOffset = this.offset + additionalOffsetDelta;
            int endOffset = startOffset + length;
            if (endOffset <= this.characters.length) {
                retval = Arrays.copyOfRange(this.characters, startOffset, endOffset);
            }
            return retval;
        }
    }
}

