/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.serializer;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.Writer;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.table.ImmutableTableSerializer;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.impl.serializer.MarshallerAbstract;
import org.omnaest.utils.table.impl.serializer.XmlModel;

class JsonMarshallerImpl<E>
extends MarshallerAbstract<E>
implements ImmutableTableSerializer.MarshallerJson<E> {
    private ImmutableTableSerializer.Marshaller.MarshallingConfiguration configuration = new ImmutableTableSerializer.Marshaller.MarshallingConfiguration();

    JsonMarshallerImpl(Table<E> table, ExceptionHandler exceptionHandler) {
        super(table, exceptionHandler);
    }

    @Override
    public Table<E> to(Appendable appendable) {
        try {
            XmlModel xmlModel = new XmlModel();
            int rowSize = this.table.rowSize();
            XmlModel.Row[] rows = new XmlModel.Row[rowSize];
            for (int index = 0; index < rowSize; ++index) {
                E[] elements = this.table.row(index).to().array();
                rows[index] = new XmlModel.Row(elements);
            }
            xmlModel.setRows(rows);
            XmlModel.MetaData metaData = new XmlModel.MetaData();
            if (this.configuration.hasEnabledRowTitles()) {
                metaData.setRowTitleList(this.table.getRowTitleList());
            }
            if (this.configuration.hasEnabledColumnTitles()) {
                metaData.setColumnTitleList(this.table.getColumnTitleList());
            }
            if (this.configuration.hasEnabledTableName()) {
                metaData.setTableName(this.table.getTableName());
            }
            xmlModel.setMetaData(metaData);
            ObjectMapper objectMapper = new ObjectMapper();
            JaxbAnnotationIntrospector annotationIntrospector = new JaxbAnnotationIntrospector();
            objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            objectMapper.setAnnotationIntrospector((AnnotationIntrospector)annotationIntrospector);
            ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
            String encoding = this.getEncoding();
            objectMapper.writeValue((Writer)byteArrayContainer.getOutputStreamWriter(encoding), xmlModel);
            appendable.append(byteArrayContainer.toString(encoding));
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
        }
        return this.table;
    }

    @Override
    protected String getEncoding() {
        return this.configuration.getEncoding();
    }

    @Override
    public ImmutableTableSerializer.MarshallerJson<E> using(ImmutableTableSerializer.Marshaller.MarshallingConfiguration configuration) {
        this.configuration = (ImmutableTableSerializer.Marshaller.MarshallingConfiguration)ObjectUtils.defaultIfNull((Object)configuration, (Object)new ImmutableTableSerializer.Marshaller.MarshallingConfiguration());
        return this;
    }
}

