/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.serializer;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.Reader;
import java.util.List;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.table.ImmutableTableSerializer;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableSerializer;
import org.omnaest.utils.table.impl.serializer.UnmarshallerAbstract;
import org.omnaest.utils.table.impl.serializer.XmlModel;

class JsonUnmarshallerImpl<E>
extends UnmarshallerAbstract<E>
implements TableSerializer.UnmarshallerJson<E> {
    private ImmutableTableSerializer.Marshaller.MarshallingConfiguration configuration = new ImmutableTableSerializer.Marshaller.MarshallingConfiguration();

    JsonUnmarshallerImpl(Table<E> table, ExceptionHandler exceptionHandler) {
        super(table, exceptionHandler);
    }

    @Override
    public Table<E> from(Reader reader) {
        try {
            XmlModel.MetaData metaData;
            boolean hasMetaData;
            this.table.clear();
            ObjectMapper objectMapper = new ObjectMapper();
            JaxbAnnotationIntrospector annotationIntrospector = new JaxbAnnotationIntrospector();
            objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            objectMapper.setAnnotationIntrospector((AnnotationIntrospector)annotationIntrospector);
            ByteArrayContainer byteArrayContainer = new ByteArrayContainer((Readable)reader);
            String encoding = this.getEncoding();
            XmlModel xmlModel = (XmlModel)objectMapper.readValue(byteArrayContainer.toString(encoding), XmlModel.class);
            XmlModel.Row<E>[] rows = xmlModel.getRows();
            int rowIndex = 0;
            if (rows != null) {
                for (XmlModel.Row row : rows) {
                    E[] elements = row.getElements();
                    this.table.setRowElements(rowIndex++, elements);
                }
            }
            boolean bl = hasMetaData = (metaData = xmlModel.getMetaData()) != null;
            if (hasMetaData) {
                boolean hasEnabledTableName = this.configuration.hasEnabledTableName();
                boolean hasEnabledRowTitles = this.configuration.hasEnabledRowTitles();
                boolean hasEnabledColumnTitles = this.configuration.hasEnabledColumnTitles();
                if (hasEnabledTableName) {
                    String tableName = metaData.getTableName();
                    this.table.setTableName(tableName);
                }
                if (hasEnabledRowTitles) {
                    List<String> rowTitleList = metaData.getRowTitleList();
                    this.table.setRowTitles(rowTitleList);
                }
                if (hasEnabledColumnTitles) {
                    List<String> columnTitleList = metaData.getColumnTitleList();
                    this.table.setColumnTitles(columnTitleList);
                }
            }
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
        }
        return this.table;
    }

    @Override
    protected String getEncoding() {
        return this.configuration.getEncoding();
    }

    @Override
    public TableSerializer.UnmarshallerJson<E> using(ImmutableTableSerializer.Marshaller.MarshallingConfiguration configuration) {
        this.configuration = (ImmutableTableSerializer.Marshaller.MarshallingConfiguration)ObjectUtils.defaultIfNull((Object)configuration, (Object)new ImmutableTableSerializer.Marshaller.MarshallingConfiguration());
        return this;
    }
}

