/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.serializer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.table.ImmutableTableSerializer;
import org.omnaest.utils.table.Table;

abstract class MarshallerAbstract<E>
implements ImmutableTableSerializer.Marshaller<E> {
    protected final Table<E> table;
    protected final ExceptionHandler exceptionHandler;

    public MarshallerAbstract(Table<E> table, ExceptionHandler exceptionHandler) {
        this.table = table;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public Table<E> to(Writer writer) {
        if (writer != null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.to(stringBuffer);
            try {
                writer.append(stringBuffer);
            }
            catch (IOException e) {
                this.exceptionHandler.handleException((Exception)e);
            }
        }
        return this.table;
    }

    @Override
    public Table<E> to(OutputStream outputStream) {
        boolean closeStream = false;
        return this.to(outputStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table<E> to(OutputStream outputStream, boolean closeStream) {
        if (outputStream != null) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                this.to(stringBuffer);
                ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
                byteArrayContainer.copyFrom((CharSequence)stringBuffer, this.getEncoding());
                byteArrayContainer.writeTo(outputStream);
            }
            finally {
                if (closeStream) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        this.exceptionHandler.handleException((Exception)e);
                    }
                }
            }
        }
        return this.table;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.to(builder);
        return builder.toString();
    }

    protected abstract String getEncoding();

    @Override
    public Table<E> to(File file) {
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            this.exceptionHandler.handleException((Exception)e);
        }
        boolean closeStream = true;
        return this.to(outputStream, true);
    }
}

