/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.serializer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.collection.CollectionUtils;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.table.Column;
import org.omnaest.utils.table.ImmutableTableSerializer;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.impl.serializer.MarshallerAbstract;

class PlainTextMarshaller<E>
extends MarshallerAbstract<E>
implements ImmutableTableSerializer.MarshallerPlainText<E> {
    private ImmutableTableSerializer.Marshaller.MarshallingConfiguration configuration = new ImmutableTableSerializer.Marshaller.MarshallingConfiguration();

    public PlainTextMarshaller(Table<E> table, ExceptionHandler exceptionHandler) {
        super(table, exceptionHandler);
    }

    @Override
    public Table<E> to(Appendable appendable) {
        if (appendable != null) {
            new TableToStringConverter(this.table).appendTableTo(appendable);
        }
        return this.table;
    }

    @Override
    public ImmutableTableSerializer.MarshallerPlainText<E> using(ImmutableTableSerializer.Marshaller.MarshallingConfiguration configuration) {
        this.configuration = (ImmutableTableSerializer.Marshaller.MarshallingConfiguration)ObjectUtils.defaultIfNull((Object)configuration, (Object)new ImmutableTableSerializer.Marshaller.MarshallingConfiguration());
        return this;
    }

    @Override
    protected String getEncoding() {
        return this.configuration.getEncoding();
    }

    private class TableToStringConverter {
        private final Table<E> table;

        public TableToStringConverter(Table<E> table) {
            this.table = table;
        }

        private Integer determineRowTitleWidth(Table<E> table) {
            List<String> rowTitleList = table.getRowTitleList();
            return this.determineWidthFor(rowTitleList);
        }

        private Integer determineWidthFor(List<String> titleList) {
            int retval = 0;
            for (String content : titleList) {
                int lengthMax = StringUtils.length((CharSequence)content);
                retval = Math.max(lengthMax, retval);
            }
            return retval;
        }

        private List<Integer> determineColumnWidthList(Table<E> table) {
            ArrayList<Integer> retlist = new ArrayList<Integer>();
            for (Column column : table.columns()) {
                if (column == null) continue;
                int lengthMax = 0;
                String columnTitle = column.getTitle();
                lengthMax = StringUtils.length((CharSequence)columnTitle);
                for (Object element : column) {
                    String content;
                    if (element == null || (content = this.convertObjectContentToString(element)) == null) continue;
                    lengthMax = Math.max(lengthMax, content.length());
                }
                retlist.add(lengthMax);
            }
            return retlist;
        }

        private String convertObjectContentToString(Object value) {
            return value != null ? String.valueOf(value) : "";
        }

        public void appendTableTo(Appendable appendable) {
            try {
                String delimiterRow = "-";
                String delimiterColumn = "|";
                String delimiterTitleColumn = "!";
                String delimiterTableTitle = "=";
                List<Integer> columnWidthList = this.determineColumnWidthList(this.table);
                boolean hasColumnTitles = this.table.hasColumnTitles();
                boolean hasRowTitles = this.table.hasRowTitles();
                boolean hasTableName = this.table.hasTableName();
                int tableCharacterWidth = CollectionUtils.sumOfCollectionInteger(columnWidthList) + columnWidthList.size() + 1;
                int rowTitlesCharacterWidth = 0;
                if (hasRowTitles) {
                    rowTitlesCharacterWidth = this.determineRowTitleWidth(this.table);
                    tableCharacterWidth += rowTitlesCharacterWidth + 1;
                }
                if (hasTableName) {
                    appendable.append(StringUtils.center((String)this.convertObjectContentToString(this.table.getTableName()), (int)tableCharacterWidth, (String)"=") + "\n");
                } else {
                    appendable.append(StringUtils.repeat((String)"-", (int)tableCharacterWidth) + "\n");
                }
                if (hasColumnTitles) {
                    if (hasRowTitles) {
                        appendable.append("!");
                        appendable.append(StringUtils.repeat((String)" ", (int)rowTitlesCharacterWidth));
                    }
                    Iterator<Integer> iteratorColumnWidthList = columnWidthList.iterator();
                    for (Column column : this.table.columns()) {
                        appendable.append("!");
                        String titleValue = column.getTitle();
                        appendable.append(StringUtils.center((String)this.convertObjectContentToString(titleValue), (int)iteratorColumnWidthList.next()));
                    }
                    appendable.append("!\n");
                }
                for (Row row : this.table.rows()) {
                    if (hasRowTitles) {
                        appendable.append("!");
                        appendable.append(StringUtils.center((String)this.convertObjectContentToString(row.getTitle()), (int)rowTitlesCharacterWidth));
                        appendable.append("!");
                    } else {
                        appendable.append("|");
                    }
                    Iterator<Integer> iteratorColumnWidthList = columnWidthList.iterator();
                    for (Object element : row) {
                        if (!iteratorColumnWidthList.hasNext()) continue;
                        appendable.append(StringUtils.center((String)this.convertObjectContentToString(element), (int)iteratorColumnWidthList.next()));
                        appendable.append("|");
                    }
                    appendable.append("\n");
                }
                appendable.append(StringUtils.repeat((String)"-", (int)tableCharacterWidth) + "\n");
            }
            catch (Exception e) {
                PlainTextMarshaller.this.exceptionHandler.handleException(e);
            }
        }
    }
}

