/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.serializer;

import java.io.Reader;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.table.ImmutableTableSerializer;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableSerializer;
import org.omnaest.utils.table.impl.serializer.UnmarshallerAbstract;

class PlainTextUnmarshaller<E>
extends UnmarshallerAbstract<E>
implements TableSerializer.UnmarshallerPlainText<E> {
    static final String delimiterRow = "-";
    static final String delimiterColumn = "|";
    static final String delimiterTitleColumn = "!";
    static final String delimiterTableTitle = "=";
    private ImmutableTableSerializer.Marshaller.MarshallingConfiguration configuration;

    public PlainTextUnmarshaller(Table<E> table, ExceptionHandler exceptionHandler) {
        super(table, exceptionHandler);
    }

    @Override
    public Table<E> from(Reader reader) {
        if (reader != null) {
            String line;
            String firstLine;
            this.table.clear();
            Scanner scanner = new Scanner(reader);
            String string = firstLine = scanner.hasNextLine() ? scanner.nextLine() : null;
            if (firstLine != null && firstLine.startsWith(delimiterTableTitle)) {
                String tableName = firstLine.replaceAll(delimiterTableTitle, "");
                this.table.setTableName(tableName);
            }
            boolean hasRowTitles = false;
            String string2 = line = scanner.hasNextLine() ? scanner.nextLine() : null;
            if (line != null && line.startsWith(delimiterTitleColumn) && line.endsWith(delimiterTitleColumn)) {
                Object[] columnTokens = StringUtils.splitPreserveAllTokens((String)line, (String)delimiterTitleColumn);
                if (columnTokens.length > 1) {
                    columnTokens = (String[])org.apache.commons.lang3.ArrayUtils.remove((Object[])columnTokens, (int)(columnTokens.length - 1));
                    columnTokens = (String[])org.apache.commons.lang3.ArrayUtils.remove((Object[])columnTokens, (int)0);
                }
                String string3 = line = scanner.hasNextLine() ? scanner.nextLine() : null;
                if (line != null && line.startsWith(delimiterTitleColumn) && columnTokens.length > 0) {
                    columnTokens = (String[])org.apache.commons.lang3.ArrayUtils.remove((Object[])columnTokens, (int)0);
                }
                columnTokens = ArrayUtils.trimStringArrayTokens((String[])columnTokens);
                this.table.setColumnTitles(Arrays.asList(columnTokens));
            }
            hasRowTitles = line != null && line.startsWith(delimiterTitleColumn);
            int rowIndexPosition = 0;
            while (line != null) {
                if (!line.startsWith(delimiterRow)) {
                    Object[] cellTokens = StringUtils.splitPreserveAllTokens((String)line, (String)delimiterColumn);
                    if (cellTokens.length > 0) {
                        cellTokens = (String[])org.apache.commons.lang3.ArrayUtils.remove((Object[])cellTokens, (int)(cellTokens.length - 1));
                    }
                    if (cellTokens.length > 0 && hasRowTitles) {
                        String[] firstCellTokens = StringUtils.splitPreserveAllTokens((String)cellTokens[0], (String)delimiterTitleColumn);
                        if ((firstCellTokens = ArrayUtils.trimStringArrayTokens((String[])firstCellTokens)).length >= 2) {
                            String titleValue = firstCellTokens[1];
                            this.table.setRowTitle(rowIndexPosition, titleValue);
                        }
                        cellTokens[0] = "";
                        if (firstCellTokens.length >= 3) {
                            cellTokens[0] = firstCellTokens[2];
                        }
                    } else if (cellTokens.length > 0) {
                        cellTokens = (String[])org.apache.commons.lang3.ArrayUtils.remove((Object[])cellTokens, (int)0);
                    }
                    cellTokens = ArrayUtils.trimStringArrayTokens((String[])cellTokens);
                    Class elementType = this.table.elementType();
                    Object[] elements = (Object[])Array.newInstance(elementType, cellTokens.length);
                    for (int ii = 0; ii < elements.length; ++ii) {
                        elements[ii] = ObjectUtils.castTo(elementType, (Object)cellTokens[ii]);
                    }
                    this.table.setRowElements(rowIndexPosition++, elements);
                }
                line = scanner.hasNextLine() ? scanner.nextLine() : null;
            }
        }
        return this.table;
    }

    @Override
    public TableSerializer.UnmarshallerPlainText<E> using(ImmutableTableSerializer.Marshaller.MarshallingConfiguration configuration) {
        this.configuration = (ImmutableTableSerializer.Marshaller.MarshallingConfiguration)ObjectUtils.defaultIfNull((Object)configuration, (Object)new ImmutableTableSerializer.Marshaller.MarshallingConfiguration());
        return this;
    }

    @Override
    protected String getEncoding() {
        return this.configuration.getEncoding();
    }
}

