/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.serializer;

import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.table.ImmutableTableSerializer;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableSerializer;
import org.omnaest.utils.table.impl.serializer.CsvMarshallerImpl;
import org.omnaest.utils.table.impl.serializer.CsvUnmarshallerImpl;
import org.omnaest.utils.table.impl.serializer.JsonMarshallerImpl;
import org.omnaest.utils.table.impl.serializer.JsonUnmarshallerImpl;
import org.omnaest.utils.table.impl.serializer.PlainTextMarshaller;
import org.omnaest.utils.table.impl.serializer.PlainTextUnmarshaller;
import org.omnaest.utils.table.impl.serializer.XHtmlMarshallerImpl;
import org.omnaest.utils.table.impl.serializer.XHtmlUnmarshallerImpl;
import org.omnaest.utils.table.impl.serializer.XmlMarshallerImpl;
import org.omnaest.utils.table.impl.serializer.XmlUnmarshallerImpl;

public class TableSerializerImpl<E>
implements TableSerializer<E> {
    private final Table<E> table;
    private final ExceptionHandler exceptionHandler;

    public TableSerializerImpl(Table<E> table, ExceptionHandler exceptionHandler) {
        this.table = table;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public TableSerializer.UnmarshallerDeclarer<E> unmarshal() {
        final Table<E> table = this.table;
        final ExceptionHandler exceptionHandler = this.exceptionHandler;
        return new TableSerializer.UnmarshallerDeclarer<E>(){

            @Override
            public TableSerializer.UnmarshallerCsv<E> asCsv() {
                return new CsvUnmarshallerImpl(table, exceptionHandler);
            }

            @Override
            public TableSerializer.UnmarshallerXml<E> asXml() {
                return new XmlUnmarshallerImpl(table, exceptionHandler);
            }

            @Override
            public TableSerializer.UnmarshallerJson<E> asJson() {
                return new JsonUnmarshallerImpl(table, exceptionHandler);
            }

            @Override
            public TableSerializer.UnmarshallerPlainText<E> asPlainText() {
                return new PlainTextUnmarshaller(table, exceptionHandler);
            }

            @Override
            public TableSerializer.UnmarshallerXHtml<E> asXHtml() {
                return new XHtmlUnmarshallerImpl(table, exceptionHandler);
            }
        };
    }

    @Override
    public ImmutableTableSerializer.MarshallerDeclarer<E> marshal() {
        final Table<E> table = this.table;
        final ExceptionHandler exceptionHandler = this.exceptionHandler;
        return new ImmutableTableSerializer.MarshallerDeclarer<E>(){

            @Override
            public ImmutableTableSerializer.MarshallerCsv<E> asCsv() {
                return new CsvMarshallerImpl(table, exceptionHandler);
            }

            @Override
            public ImmutableTableSerializer.MarshallerXml<E> asXml() {
                return new XmlMarshallerImpl(table, exceptionHandler);
            }

            @Override
            public ImmutableTableSerializer.MarshallerJson<E> asJson() {
                return new JsonMarshallerImpl(table, exceptionHandler);
            }

            @Override
            public ImmutableTableSerializer.MarshallerPlainText<E> asPlainText() {
                return new PlainTextMarshaller(table, exceptionHandler);
            }

            @Override
            public ImmutableTableSerializer.MarshallerXHtml<E> asXHtml() {
                return new XHtmlMarshallerImpl(table, exceptionHandler);
            }
        };
    }
}

