/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.serializer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.apache.commons.io.input.CharSequenceReader;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableSerializer;

abstract class UnmarshallerAbstract<E>
implements TableSerializer.Unmarshaller<E> {
    protected final Table<E> table;
    protected final ExceptionHandler exceptionHandler;

    public UnmarshallerAbstract(Table<E> table, ExceptionHandler exceptionHandler) {
        this.table = table;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public Table<E> from(InputStream inputStream) {
        if (inputStream != null) {
            ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
            byteArrayContainer.copyFrom(inputStream);
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.exceptionHandler.handleException((Exception)e);
            }
            this.from(byteArrayContainer.getReader(this.getEncoding()));
        }
        return this.table;
    }

    protected abstract String getEncoding();

    @Override
    public Table<E> from(CharSequence charSequence) {
        return this.from((Reader)new CharSequenceReader(charSequence));
    }

    @Override
    public Table<E> from(File file) {
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            this.exceptionHandler.handleException((Exception)e);
        }
        return this.from(inputStream);
    }

    @Override
    public Table<E> from(URL url) {
        InputStream inputStream = null;
        try {
            inputStream = url == null ? null : url.openStream();
        }
        catch (IOException e) {
            this.exceptionHandler.handleException((Exception)e);
        }
        return this.from(inputStream);
    }
}

