/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.serializer;

import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringEscapeUtils;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableSerializer;
import org.omnaest.utils.table.impl.serializer.XHtmlMarshallerImpl;
import org.omnaest.utils.table.impl.serializer.XmlUnmarshallerImpl;
import org.omnaest.utils.xml.XMLHelper;

class XHtmlUnmarshallerImpl<E>
extends XmlUnmarshallerImpl<E>
implements TableSerializer.UnmarshallerXHtml<E> {
    XHtmlUnmarshallerImpl(Table<E> table, ExceptionHandler exceptionHandler) {
        super(table, exceptionHandler);
    }

    @Override
    public Table<E> from(Reader reader) {
        try {
            ByteArrayContainer byteArrayContainerSource = new ByteArrayContainer().copyFrom((Readable)reader);
            String xhtmlContent = StringEscapeUtils.unescapeHtml4((String)byteArrayContainerSource.toString());
            StringReader readerOfConvertedContent = new StringReader(xhtmlContent);
            ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
            OutputStreamWriter writer = byteArrayContainer.getOutputStreamWriter();
            InputStream inputStreamXSLT = XHtmlMarshallerImpl.class.getResourceAsStream("/XHtmlToXml.xsl");
            StreamSource xslt = new StreamSource(inputStreamXSLT);
            StreamSource xml = new StreamSource(readerOfConvertedContent);
            StreamResult result = new StreamResult(writer);
            XMLHelper.transform((StreamSource)xslt, (StreamSource)xml, (StreamResult)result, (ExceptionHandler)this.exceptionHandler, (XMLHelper.XSLTransformerConfiguration)new XMLHelper.XSLTransformerConfiguration());
            ((Writer)writer).close();
            super.from(byteArrayContainer.getReader(this.getEncoding()));
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
        }
        return this.table;
    }
}

