/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.serializer;

import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.table.ImmutableTableSerializer;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.impl.serializer.MarshallerAbstract;
import org.omnaest.utils.table.impl.serializer.XmlModel;
import org.omnaest.utils.xml.JAXBXMLHelper;

class XmlMarshallerImpl<E>
extends MarshallerAbstract<E>
implements ImmutableTableSerializer.MarshallerXml<E> {
    private ImmutableTableSerializer.Marshaller.MarshallingConfiguration configuration = new ImmutableTableSerializer.Marshaller.MarshallingConfiguration();

    XmlMarshallerImpl(Table<E> table, ExceptionHandler exceptionHandler) {
        super(table, exceptionHandler);
    }

    @Override
    public Table<E> to(Appendable appendable) {
        try {
            XmlModel xmlModel = new XmlModel();
            int rowSize = this.table.rowSize();
            XmlModel.Row[] rows = new XmlModel.Row[rowSize];
            for (int index = 0; index < rowSize; ++index) {
                E[] elements = this.table.row(index).to().array();
                rows[index] = new XmlModel.Row(elements);
            }
            xmlModel.setRows(rows);
            XmlModel.MetaData metaData = new XmlModel.MetaData();
            if (this.configuration.hasEnabledRowTitles()) {
                metaData.setRowTitleList(this.table.getRowTitleList());
            }
            if (this.configuration.hasEnabledColumnTitles()) {
                metaData.setColumnTitleList(this.table.getColumnTitleList());
            }
            if (this.configuration.hasEnabledTableName()) {
                metaData.setTableName(this.table.getTableName());
            }
            xmlModel.setMetaData(metaData);
            Class elementType = this.table.elementType();
            JAXBXMLHelper.MarshallingConfiguration configuration = new JAXBXMLHelper.MarshallingConfiguration().setExceptionHandler(this.exceptionHandler).setKnownTypes(new Class[]{ArrayUtils.arrayType(elementType)});
            String objectAsXML = JAXBXMLHelper.storeObjectAsXML(xmlModel, (JAXBXMLHelper.MarshallingConfiguration)configuration);
            appendable.append(objectAsXML);
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
        }
        return this.table;
    }

    @Override
    protected String getEncoding() {
        return this.configuration.getEncoding();
    }

    @Override
    public ImmutableTableSerializer.MarshallerXml<E> using(ImmutableTableSerializer.Marshaller.MarshallingConfiguration configuration) {
        this.configuration = (ImmutableTableSerializer.Marshaller.MarshallingConfiguration)ObjectUtils.defaultIfNull((Object)configuration, (Object)new ImmutableTableSerializer.Marshaller.MarshallingConfiguration());
        return this;
    }
}

