/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.serializer;

import java.io.Reader;
import java.util.List;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.table.ImmutableTableSerializer;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableSerializer;
import org.omnaest.utils.table.impl.serializer.UnmarshallerAbstract;
import org.omnaest.utils.table.impl.serializer.XmlModel;
import org.omnaest.utils.xml.JAXBXMLHelper;

class XmlUnmarshallerImpl<E>
extends UnmarshallerAbstract<E>
implements TableSerializer.UnmarshallerXml<E> {
    private ImmutableTableSerializer.Marshaller.MarshallingConfiguration configuration = new ImmutableTableSerializer.Marshaller.MarshallingConfiguration();

    XmlUnmarshallerImpl(Table<E> table, ExceptionHandler exceptionHandler) {
        super(table, exceptionHandler);
    }

    @Override
    public Table<E> from(Reader reader) {
        try {
            this.table.clear();
            ByteArrayContainer byteArrayContainer = new ByteArrayContainer((Readable)reader);
            Class elementType = this.table.elementType();
            Class arrayType = ArrayUtils.arrayType(elementType);
            JAXBXMLHelper.UnmarshallingConfiguration unmarshallingConfiguration = new JAXBXMLHelper.UnmarshallingConfiguration().setExceptionHandler(this.exceptionHandler).setKnownTypes(new Class[]{arrayType, elementType});
            XmlModel xmlModel = (XmlModel)JAXBXMLHelper.loadObjectFromXML((CharSequence)byteArrayContainer.toString(this.getEncoding()), XmlModel.class, (JAXBXMLHelper.UnmarshallingConfiguration)unmarshallingConfiguration);
            if (xmlModel != null) {
                XmlModel.MetaData metaData;
                boolean hasMetaData;
                XmlModel.Row<E>[] rows = xmlModel.getRows();
                int rowIndex = 0;
                if (rows != null) {
                    for (XmlModel.Row row : rows) {
                        E[] elements = row.getElements();
                        this.table.setRowElements(rowIndex++, elements);
                    }
                }
                boolean bl = hasMetaData = (metaData = xmlModel.getMetaData()) != null;
                if (hasMetaData) {
                    boolean hasEnabledTableName = this.configuration.hasEnabledTableName();
                    boolean hasEnabledRowTitles = this.configuration.hasEnabledRowTitles();
                    boolean hasEnabledColumnTitles = this.configuration.hasEnabledColumnTitles();
                    if (hasEnabledTableName) {
                        String tableName = metaData.getTableName();
                        this.table.setTableName(tableName);
                    }
                    if (hasEnabledRowTitles) {
                        List<String> rowTitleList = metaData.getRowTitleList();
                        this.table.setRowTitles(rowTitleList);
                    }
                    if (hasEnabledColumnTitles) {
                        List<String> columnTitleList = metaData.getColumnTitleList();
                        this.table.setColumnTitles(columnTitleList);
                    }
                }
            }
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
        }
        return this.table;
    }

    @Override
    protected String getEncoding() {
        return this.configuration.getEncoding();
    }

    @Override
    public TableSerializer.UnmarshallerXml<E> using(ImmutableTableSerializer.Marshaller.MarshallingConfiguration configuration) {
        this.configuration = (ImmutableTableSerializer.Marshaller.MarshallingConfiguration)ObjectUtils.defaultIfNull((Object)configuration, (Object)new ImmutableTableSerializer.Marshaller.MarshallingConfiguration());
        return this;
    }
}

