/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.table.impl.transformer;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterSerializable;
import org.omnaest.utils.structure.iterator.IterableUtils;
import org.omnaest.utils.table.Column;
import org.omnaest.utils.table.Columns;
import org.omnaest.utils.table.Row;
import org.omnaest.utils.table.Rows;
import org.omnaest.utils.table.Table;
import org.omnaest.utils.table.TableDataSource;
import org.omnaest.utils.table.TableTransformer;
import org.omnaest.utils.table.impl.ArrayTable;
import org.omnaest.utils.table.impl.transformer.TableToArrayConverter;

public class TableTransformerImpl<E>
implements TableTransformer<E> {
    private final Table<E> table;

    public TableTransformerImpl(Table<E> table) {
        this.table = table;
    }

    @Override
    public E[][] array() {
        return new TableToArrayConverter<E>().convert(this.table);
    }

    @Override
    public String string() {
        return this.table.serializer().marshal().asPlainText().toString();
    }

    @Override
    public Map<E, E[]> map() {
        boolean columnIndex = false;
        return this.map(false);
    }

    @Override
    public Map<E, E[]> map(int columnIndex) {
        LinkedHashMap map = new LinkedHashMap();
        return this.map(map, columnIndex);
    }

    @Override
    public SortedMap<E, E[]> sortedMap() {
        boolean columnIndex = false;
        return this.sortedMap(0);
    }

    @Override
    public SortedMap<E, E[]> sortedMap(int columnIndex) {
        TreeMap map = new TreeMap();
        return this.map(map, columnIndex);
    }

    @Override
    public SortedMap<E, E[]> sortedMap(Comparator<E> comparator) {
        boolean columnIndex = false;
        return this.sortedMap(comparator, 0);
    }

    @Override
    public SortedMap<E, E[]> sortedMap(Comparator<E> comparator, int columnIndex) {
        TreeMap map = new TreeMap(comparator);
        return this.map(map, columnIndex);
    }

    @Override
    public <M extends Map<E, E[]>> M map(M map) {
        boolean columnIndex = false;
        return this.map(map, 0);
    }

    @Override
    public <M extends Map<E, E[]>> M map(M map, int columnIndex) {
        E[][] elementMatrix;
        if (map == null) {
            map = new LinkedHashMap();
        }
        for (E[] elements : elementMatrix = this.array()) {
            E key = elements[columnIndex];
            E[] value = elements;
            map.put(key, value);
        }
        return (M)map;
    }

    @Override
    public Map<E, E> map(int columnIndexKey, int columnIndexValue) {
        LinkedHashMap map = new LinkedHashMap();
        return this.map(map, columnIndexKey, columnIndexValue);
    }

    @Override
    public <M extends Map<E, E>> M map(M map, int columnIndexKey, int columnIndexValue) {
        E[][] elementMatrix;
        if (map == null) {
            map = new LinkedHashMap();
        }
        for (E[] elements : elementMatrix = this.array()) {
            E key = elements[columnIndexKey];
            E value = elements[columnIndexValue];
            map.put(key, value);
        }
        return (M)map;
    }

    @Override
    public SortedMap<E, E> sortedMap(int columnIndexKey, int columnIndexValue) {
        TreeMap map = new TreeMap();
        return this.map(map, columnIndexKey, columnIndexValue);
    }

    @Override
    public SortedMap<E, E> sortedMap(Comparator<E> comparator, int columnIndexKey, int columnIndexValue) {
        TreeMap map = new TreeMap(comparator);
        return this.map(map, columnIndexKey, columnIndexValue);
    }

    @Override
    public Table<E> swapped() {
        final Table<E> table = this.table;
        ArrayTable retval = new ArrayTable(this.table.elementType());
        retval.copy().from(new TableDataSource<E>(){
            private static final long serialVersionUID = 5929745410356641061L;

            @Override
            public String getTableName() {
                return table.getTableName();
            }

            @Override
            public String[] getColumnTitles() {
                return table.getRowTitles();
            }

            @Override
            public Iterable<E[]> rowElements() {
                Columns columns = table.columns();
                ElementConverterSerializable elementConverter = new ElementConverterSerializable<Column<E>, E[]>(){
                    private static final long serialVersionUID = -3322314134295745486L;

                    public E[] convert(Column<E> column) {
                        return column.to().array();
                    }
                };
                return IterableUtils.convert(columns, (ElementConverter)elementConverter);
            }

            @Override
            public String[] getRowTitles() {
                return table.getColumnTitles();
            }
        });
        return retval;
    }

    @Override
    public <N> Table<N> converted(final Class<N> elementType, final ElementConverter<E, N> elementConverter) {
        final Table<E> table = this.table;
        ArrayTable<N> retval = new ArrayTable<N>(elementType);
        retval.copy().from(new TableDataSource<N>(){
            private static final long serialVersionUID = 5929745410356641061L;

            @Override
            public String getTableName() {
                return table.getTableName();
            }

            @Override
            public String[] getColumnTitles() {
                return table.getColumnTitles();
            }

            @Override
            public Iterable<N[]> rowElements() {
                boolean detached = true;
                Rows rows = table.rows(true);
                return IterableUtils.convert(rows, (ElementConverter)new ElementConverterSerializable<Row<E>, N[]>(){
                    private static final long serialVersionUID = -5480913656973372565L;

                    public N[] convert(Row<E> row) {
                        return ArrayUtils.convertArray((Object[])row.to().array(), (Class)elementType, (ElementConverter)elementConverter);
                    }
                });
            }

            @Override
            public String[] getRowTitles() {
                return table.getRowTitles();
            }
        });
        return retval;
    }

    @Override
    public Table<E> subTable(final int rowIndexFrom, final int rowIndexTo, final int columnIndexFrom, final int columnIndexTo) {
        final Table<E> table = this.table;
        ArrayTable retval = new ArrayTable(table.elementType());
        retval.copy().from(new TableDataSource<E>(){
            private static final long serialVersionUID = -8443061443474858835L;

            @Override
            public String getTableName() {
                return table.getTableName();
            }

            @Override
            public String[] getColumnTitles() {
                return Arrays.copyOfRange(table.getColumnTitles(), columnIndexFrom, columnIndexTo);
            }

            @Override
            public String[] getRowTitles() {
                return Arrays.copyOfRange(table.getRowTitles(), rowIndexFrom, rowIndexTo);
            }

            @Override
            public Iterable<E[]> rowElements() {
                boolean detached = true;
                BitSet filter = new BitSet();
                filter.set(rowIndexFrom, rowIndexTo);
                Rows rows = table.rows(filter, true);
                return IterableUtils.convert(rows, (ElementConverter)new ElementConverterSerializable<Row<E>, E[]>(){
                    private static final long serialVersionUID = -5480913656973372565L;

                    public E[] convert(Row<E> row) {
                        return Arrays.copyOfRange(row.to().array(), columnIndexFrom, columnIndexTo);
                    }
                });
            }
        });
        return retval;
    }
}

