/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.core;

import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.time.Clock;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.onebusaway.core.ObjectMappers;
import org.onebusaway.core.Properties;
import org.onebusaway.core.Utils;
import org.onebusaway.core.http.HttpClient;
import org.onebusaway.core.http.PhantomReachableClosingHttpClient;
import org.onebusaway.core.http.RetryingHttpClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eBo\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u001b\u001a\u00020\u001cR\u0013\u0010\u0012\u001a\u00020\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0014R\u0013\u0010\t\u001a\u00020\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0014R\u0013\u0010\u0007\u001a\u00020\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0015R\u001f\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\f8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0016R\u0013\u0010\u0004\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0017R\u0013\u0010\u0005\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0018R\u0013\u0010\u0010\u001a\u00020\u00118\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\f8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0016R\u0013\u0010\u000e\u001a\u00020\u000f8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lorg/onebusaway/core/ClientOptions;", "", "originalHttpClient", "Lorg/onebusaway/core/http/HttpClient;", "httpClient", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "clock", "Ljava/time/Clock;", "baseUrl", "", "headers", "Lcom/google/common/collect/ListMultimap;", "queryParams", "responseValidation", "", "maxRetries", "", "apiKey", "(Lorg/onebusaway/core/http/HttpClient;Lorg/onebusaway/core/http/HttpClient;Lcom/fasterxml/jackson/databind/json/JsonMapper;Ljava/time/Clock;Ljava/lang/String;Lcom/google/common/collect/ListMultimap;Lcom/google/common/collect/ListMultimap;ZILjava/lang/String;)V", "()Ljava/lang/String;", "()Ljava/time/Clock;", "()Lcom/google/common/collect/ListMultimap;", "()Lorg/onebusaway/core/http/HttpClient;", "()Lcom/fasterxml/jackson/databind/json/JsonMapper;", "()I", "()Z", "toBuilder", "Lorg/onebusaway/core/ClientOptions$Builder;", "Builder", "Companion", "onebusaway-sdk-java-core"})
public final class ClientOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpClient originalHttpClient;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final JsonMapper jsonMapper;
    @NotNull
    private final Clock clock;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final ListMultimap<String, String> headers;
    @NotNull
    private final ListMultimap<String, String> queryParams;
    private final boolean responseValidation;
    private final int maxRetries;
    @NotNull
    private final String apiKey;
    @NotNull
    public static final String PRODUCTION_URL = "https://api.pugetsound.onebusaway.org";

    private ClientOptions(HttpClient originalHttpClient, HttpClient httpClient, JsonMapper jsonMapper, Clock clock, String baseUrl, ListMultimap<String, String> headers, ListMultimap<String, String> queryParams, boolean responseValidation, int maxRetries, String apiKey) {
        this.originalHttpClient = originalHttpClient;
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.clock = clock;
        this.baseUrl = baseUrl;
        this.headers = headers;
        this.queryParams = queryParams;
        this.responseValidation = responseValidation;
        this.maxRetries = maxRetries;
        this.apiKey = apiKey;
    }

    @JvmName(name="httpClient")
    @NotNull
    public final HttpClient httpClient() {
        return this.httpClient;
    }

    @JvmName(name="jsonMapper")
    @NotNull
    public final JsonMapper jsonMapper() {
        return this.jsonMapper;
    }

    @JvmName(name="clock")
    @NotNull
    public final Clock clock() {
        return this.clock;
    }

    @JvmName(name="baseUrl")
    @NotNull
    public final String baseUrl() {
        return this.baseUrl;
    }

    @JvmName(name="headers")
    @NotNull
    public final ListMultimap<String, String> headers() {
        return this.headers;
    }

    @JvmName(name="queryParams")
    @NotNull
    public final ListMultimap<String, String> queryParams() {
        return this.queryParams;
    }

    @JvmName(name="responseValidation")
    public final boolean responseValidation() {
        return this.responseValidation;
    }

    @JvmName(name="maxRetries")
    public final int maxRetries() {
        return this.maxRetries;
    }

    @JvmName(name="apiKey")
    @NotNull
    public final String apiKey() {
        return this.apiKey;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder().from$onebusaway_sdk_java_core(this);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @JvmStatic
    @NotNull
    public static final ClientOptions fromEnv() {
        return Companion.fromEnv();
    }

    public /* synthetic */ ClientOptions(HttpClient originalHttpClient, HttpClient httpClient, JsonMapper jsonMapper, Clock clock, String baseUrl, ListMultimap headers, ListMultimap queryParams, boolean responseValidation, int maxRetries, String apiKey, DefaultConstructorMarker $constructor_marker) {
        this(originalHttpClient, httpClient, jsonMapper, clock, baseUrl, (ListMultimap<String, String>)headers, (ListMultimap<String, String>)queryParams, responseValidation, maxRetries, apiKey);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u001c\n\u0002\b\f\n\u0002\u0010\"\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0015\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0017J\u0006\u0010\u0018\u001a\u00020\u0000J \u0010\b\u001a\u00020\u00002\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001a0\u0019J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u001b\u001a\u00020\u00002\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001a0\u0019J \u0010\u001c\u001a\u00020\u00002\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001a0\u0019J\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004J\u001c\u0010 \u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00042\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aJ\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004J\u001c\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00042\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aJ \u0010\u0010\u001a\u00020\u00002\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001a0\u0019J\u0014\u0010%\u001a\u00020\u00002\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'J\u0014\u0010(\u001a\u00020\u00002\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040'J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0004J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0004J \u0010,\u001a\u00020\u00002\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001a0\u0019J \u0010-\u001a\u00020\u00002\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001a0\u0019J\u0016\u0010.\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004J\u001c\u0010.\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00042\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aJ\u0016\u0010/\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004J\u001c\u0010/\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00042\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/onebusaway/core/ClientOptions$Builder;", "", "()V", "apiKey", "", "baseUrl", "clock", "Ljava/time/Clock;", "headers", "Lcom/google/common/collect/ListMultimap;", "httpClient", "Lorg/onebusaway/core/http/HttpClient;", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "maxRetries", "", "queryParams", "responseValidation", "", "build", "Lorg/onebusaway/core/ClientOptions;", "from", "clientOptions", "from$onebusaway_sdk_java_core", "fromEnv", "", "", "putAllHeaders", "putAllQueryParams", "putHeader", "name", "value", "putHeaders", "values", "putQueryParam", "key", "putQueryParams", "removeAllHeaders", "names", "", "removeAllQueryParams", "keys", "removeHeaders", "removeQueryParams", "replaceAllHeaders", "replaceAllQueryParams", "replaceHeaders", "replaceQueryParams", "onebusaway-sdk-java-core"})
    @SourceDebugExtension(value={"SMAP\nClientOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientOptions.kt\norg/onebusaway/core/ClientOptions$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n1#2:184\n1855#3,2:185\n1855#3,2:187\n*S KotlinDebug\n*F\n+ 1 ClientOptions.kt\norg/onebusaway/core/ClientOptions$Builder\n*L\n100#1:185,2\n131#1:187,2\n*E\n"})
    public static final class Builder {
        @Nullable
        private HttpClient httpClient;
        @NotNull
        private JsonMapper jsonMapper = ObjectMappers.jsonMapper();
        @NotNull
        private Clock clock;
        @NotNull
        private String baseUrl;
        @NotNull
        private ListMultimap<String, String> headers;
        @NotNull
        private ListMultimap<String, String> queryParams;
        private boolean responseValidation;
        private int maxRetries;
        @Nullable
        private String apiKey;

        public Builder() {
            Clock clock = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemUTC(...)");
            this.clock = clock;
            this.baseUrl = ClientOptions.PRODUCTION_URL;
            ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"create(...)");
            this.headers = (ListMultimap)arrayListMultimap;
            ArrayListMultimap arrayListMultimap2 = ArrayListMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap2, (String)"create(...)");
            this.queryParams = (ListMultimap)arrayListMultimap2;
            this.maxRetries = 2;
        }

        public final /* synthetic */ Builder from$onebusaway_sdk_java_core(ClientOptions clientOptions) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
            Builder $this$from_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$from_u24lambda_u240.httpClient = clientOptions.originalHttpClient;
            $this$from_u24lambda_u240.jsonMapper = clientOptions.jsonMapper();
            $this$from_u24lambda_u240.clock = clientOptions.clock();
            $this$from_u24lambda_u240.baseUrl = clientOptions.baseUrl();
            ArrayListMultimap arrayListMultimap = ArrayListMultimap.create((Multimap)((Multimap)clientOptions.headers()));
            Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"create(...)");
            $this$from_u24lambda_u240.headers = (ListMultimap)arrayListMultimap;
            ArrayListMultimap arrayListMultimap2 = ArrayListMultimap.create((Multimap)((Multimap)clientOptions.queryParams()));
            Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap2, (String)"create(...)");
            $this$from_u24lambda_u240.queryParams = (ListMultimap)arrayListMultimap2;
            $this$from_u24lambda_u240.responseValidation = clientOptions.responseValidation();
            $this$from_u24lambda_u240.maxRetries = clientOptions.maxRetries();
            $this$from_u24lambda_u240.apiKey = clientOptions.apiKey();
            return builder;
        }

        @NotNull
        public final Builder httpClient(@NotNull HttpClient httpClient) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
            Builder $this$httpClient_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$httpClient_u24lambda_u241.httpClient = httpClient;
            return builder;
        }

        @NotNull
        public final Builder jsonMapper(@NotNull JsonMapper jsonMapper) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
            Builder $this$jsonMapper_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$jsonMapper_u24lambda_u242.jsonMapper = jsonMapper;
            return builder;
        }

        @NotNull
        public final Builder clock(@NotNull Clock clock) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            Builder $this$clock_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$clock_u24lambda_u243.clock = clock;
            return builder;
        }

        @NotNull
        public final Builder baseUrl(@NotNull String baseUrl) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Builder $this$baseUrl_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$baseUrl_u24lambda_u244.baseUrl = baseUrl;
            return builder;
        }

        @NotNull
        public final Builder headers(@NotNull Map<String, ? extends Iterable<String>> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$headers_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u245.headers.clear();
            $this$headers_u24lambda_u245.putAllHeaders(headers);
            return builder;
        }

        @NotNull
        public final Builder putHeader(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putHeader_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$putHeader_u24lambda_u246.headers.put((Object)name, (Object)value);
            return builder;
        }

        @NotNull
        public final Builder putHeaders(@NotNull String name, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$putHeaders_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$putHeaders_u24lambda_u247.headers.putAll((Object)name, values);
            return builder;
        }

        @NotNull
        public final Builder putAllHeaders(@NotNull Map<String, ? extends Iterable<String>> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$putAllHeaders_u24lambda_u249 = builder = this;
            boolean bl = false;
            headers.forEach((arg_0, arg_1) -> Builder.putAllHeaders$lambda$9$lambda$8((Function2)new Function2<String, Iterable<? extends String>, Unit>((Object)$this$putAllHeaders_u24lambda_u249){

                public final void invoke(@NotNull String p0, @NotNull Iterable<String> p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    ((Builder)this.receiver).putHeaders(p0, p1);
                }
            }, arg_0, arg_1));
            return builder;
        }

        @NotNull
        public final Builder replaceHeaders(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$replaceHeaders_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$replaceHeaders_u24lambda_u2410.headers.replaceValues((Object)name, (Iterable)CollectionsKt.listOf((Object)value));
            return builder;
        }

        @NotNull
        public final Builder replaceHeaders(@NotNull String name, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$replaceHeaders_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$replaceHeaders_u24lambda_u2411.headers.replaceValues((Object)name, values);
            return builder;
        }

        @NotNull
        public final Builder replaceAllHeaders(@NotNull Map<String, ? extends Iterable<String>> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$replaceAllHeaders_u24lambda_u2413 = builder = this;
            boolean bl = false;
            headers.forEach((arg_0, arg_1) -> Builder.replaceAllHeaders$lambda$13$lambda$12((Function2)new Function2<String, Iterable<? extends String>, Unit>((Object)$this$replaceAllHeaders_u24lambda_u2413){

                public final void invoke(@NotNull String p0, @NotNull Iterable<String> p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    ((Builder)this.receiver).replaceHeaders(p0, p1);
                }
            }, arg_0, arg_1));
            return builder;
        }

        @NotNull
        public final Builder removeHeaders(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$removeHeaders_u24lambda_u2414 = builder = this;
            boolean bl = false;
            $this$removeHeaders_u24lambda_u2414.headers.removeAll((Object)name);
            return builder;
        }

        @NotNull
        public final Builder removeAllHeaders(@NotNull Set<String> names) {
            Builder builder;
            Intrinsics.checkNotNullParameter(names, (String)"names");
            Builder $this$removeAllHeaders_u24lambda_u2415 = builder = this;
            boolean bl = false;
            Iterable $this$forEach$iv = names;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p0 = (String)element$iv;
                boolean bl2 = false;
                $this$removeAllHeaders_u24lambda_u2415.removeHeaders(p0);
            }
            return builder;
        }

        @NotNull
        public final Builder queryParams(@NotNull Map<String, ? extends Iterable<String>> queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Builder $this$queryParams_u24lambda_u2416 = builder = this;
            boolean bl = false;
            $this$queryParams_u24lambda_u2416.queryParams.clear();
            $this$queryParams_u24lambda_u2416.putAllQueryParams(queryParams);
            return builder;
        }

        @NotNull
        public final Builder putQueryParam(@NotNull String key, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putQueryParam_u24lambda_u2417 = builder = this;
            boolean bl = false;
            $this$putQueryParam_u24lambda_u2417.queryParams.put((Object)key, (Object)value);
            return builder;
        }

        @NotNull
        public final Builder putQueryParams(@NotNull String key, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$putQueryParams_u24lambda_u2418 = builder = this;
            boolean bl = false;
            $this$putQueryParams_u24lambda_u2418.queryParams.putAll((Object)key, values);
            return builder;
        }

        @NotNull
        public final Builder putAllQueryParams(@NotNull Map<String, ? extends Iterable<String>> queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Builder $this$putAllQueryParams_u24lambda_u2420 = builder = this;
            boolean bl = false;
            queryParams.forEach((arg_0, arg_1) -> Builder.putAllQueryParams$lambda$20$lambda$19((Function2)new Function2<String, Iterable<? extends String>, Unit>((Object)$this$putAllQueryParams_u24lambda_u2420){

                public final void invoke(@NotNull String p0, @NotNull Iterable<String> p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    ((Builder)this.receiver).putQueryParams(p0, p1);
                }
            }, arg_0, arg_1));
            return builder;
        }

        @NotNull
        public final Builder replaceQueryParams(@NotNull String key, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$replaceQueryParams_u24lambda_u2421 = builder = this;
            boolean bl = false;
            $this$replaceQueryParams_u24lambda_u2421.queryParams.replaceValues((Object)key, (Iterable)CollectionsKt.listOf((Object)value));
            return builder;
        }

        @NotNull
        public final Builder replaceQueryParams(@NotNull String key, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$replaceQueryParams_u24lambda_u2422 = builder = this;
            boolean bl = false;
            $this$replaceQueryParams_u24lambda_u2422.queryParams.replaceValues((Object)key, values);
            return builder;
        }

        @NotNull
        public final Builder replaceAllQueryParams(@NotNull Map<String, ? extends Iterable<String>> queryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(queryParams, (String)"queryParams");
            Builder $this$replaceAllQueryParams_u24lambda_u2424 = builder = this;
            boolean bl = false;
            queryParams.forEach((arg_0, arg_1) -> Builder.replaceAllQueryParams$lambda$24$lambda$23((Function2)new Function2<String, Iterable<? extends String>, Unit>((Object)$this$replaceAllQueryParams_u24lambda_u2424){

                public final void invoke(@NotNull String p0, @NotNull Iterable<String> p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    ((Builder)this.receiver).replaceQueryParams(p0, p1);
                }
            }, arg_0, arg_1));
            return builder;
        }

        @NotNull
        public final Builder removeQueryParams(@NotNull String key) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder $this$removeQueryParams_u24lambda_u2425 = builder = this;
            boolean bl = false;
            $this$removeQueryParams_u24lambda_u2425.queryParams.removeAll((Object)key);
            return builder;
        }

        @NotNull
        public final Builder removeAllQueryParams(@NotNull Set<String> keys) {
            Builder builder;
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Builder $this$removeAllQueryParams_u24lambda_u2426 = builder = this;
            boolean bl = false;
            Iterable $this$forEach$iv = keys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p0 = (String)element$iv;
                boolean bl2 = false;
                $this$removeAllQueryParams_u24lambda_u2426.removeQueryParams(p0);
            }
            return builder;
        }

        @NotNull
        public final Builder responseValidation(boolean responseValidation) {
            Builder builder;
            Builder $this$responseValidation_u24lambda_u2427 = builder = this;
            boolean bl = false;
            $this$responseValidation_u24lambda_u2427.responseValidation = responseValidation;
            return builder;
        }

        @NotNull
        public final Builder maxRetries(int maxRetries) {
            Builder builder;
            Builder $this$maxRetries_u24lambda_u2428 = builder = this;
            boolean bl = false;
            $this$maxRetries_u24lambda_u2428.maxRetries = maxRetries;
            return builder;
        }

        @NotNull
        public final Builder apiKey(@NotNull String apiKey) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Builder $this$apiKey_u24lambda_u2429 = builder = this;
            boolean bl = false;
            $this$apiKey_u24lambda_u2429.apiKey = apiKey;
            return builder;
        }

        @NotNull
        public final Builder fromEnv() {
            Builder builder;
            block0: {
                String string;
                Builder $this$fromEnv_u24lambda_u2431 = builder = this;
                boolean bl = false;
                String string2 = string = System.getenv("ONEBUSAWAY_API_KEY");
                if (string2 == null) break block0;
                Intrinsics.checkNotNull((Object)string2);
                String it = string;
                boolean bl2 = false;
                $this$fromEnv_u24lambda_u2431.apiKey(it);
            }
            return builder;
        }

        @NotNull
        public final ClientOptions build() {
            if (this.httpClient == null) {
                boolean $i$a$-checkNotNull-ClientOptions$Builder$build$32 = false;
                String $i$a$-checkNotNull-ClientOptions$Builder$build$32 = "`httpClient` is required but was not set";
                throw new IllegalStateException($i$a$-checkNotNull-ClientOptions$Builder$build$32.toString());
            }
            if (this.apiKey == null) {
                boolean $i$a$-checkNotNull-ClientOptions$Builder$build$42 = false;
                String $i$a$-checkNotNull-ClientOptions$Builder$build$42 = "`apiKey` is required but was not set";
                throw new IllegalStateException($i$a$-checkNotNull-ClientOptions$Builder$build$42.toString());
            }
            ArrayListMultimap headers = ArrayListMultimap.create();
            ArrayListMultimap queryParams = ArrayListMultimap.create();
            headers.put((Object)"X-Stainless-Lang", (Object)"java");
            headers.put((Object)"X-Stainless-Arch", (Object)Properties.getOsArch());
            headers.put((Object)"X-Stainless-OS", (Object)Properties.getOsName());
            headers.put((Object)"X-Stainless-OS-Version", (Object)Properties.getOsVersion());
            headers.put((Object)"X-Stainless-Package-Version", (Object)Properties.getPackageVersion());
            headers.put((Object)"X-Stainless-Runtime", (Object)"JRE");
            headers.put((Object)"X-Stainless-Runtime-Version", (Object)Properties.getJavaVersion());
            CharSequence charSequence = this.apiKey;
            if (!(charSequence == null || charSequence.length() == 0)) {
                queryParams.put((Object)"key", (Object)this.apiKey);
            }
            this.headers.asMap().forEach((arg_0, arg_1) -> Builder.build$lambda$34((Function2)new Function2<String, Iterable<? extends String>, Unit>((Object)headers){

                public final void invoke(String p0, Iterable<String> p1) {
                    ((ArrayListMultimap)this.receiver).replaceValues((Object)p0, p1);
                }
            }, arg_0, arg_1));
            this.queryParams.asMap().forEach((arg_0, arg_1) -> Builder.build$lambda$36((Function2)new Function2<String, Iterable<? extends String>, Unit>((Object)queryParams){

                public final void invoke(String p0, Iterable<String> p1) {
                    ((ArrayListMultimap)this.receiver).replaceValues((Object)p0, p1);
                }
            }, arg_0, arg_1));
            HttpClient httpClient = this.httpClient;
            Intrinsics.checkNotNull((Object)httpClient);
            RetryingHttpClient.Builder builder = RetryingHttpClient.Companion.builder();
            HttpClient httpClient2 = this.httpClient;
            Intrinsics.checkNotNull((Object)httpClient2);
            HttpClient httpClient3 = new PhantomReachableClosingHttpClient(builder.httpClient(httpClient2).clock(this.clock).maxRetries(this.maxRetries).build());
            Intrinsics.checkNotNull((Object)headers);
            ListMultimap listMultimap = Utils.toImmutable((ListMultimap)headers);
            Intrinsics.checkNotNull((Object)queryParams);
            ListMultimap listMultimap2 = Utils.toImmutable((ListMultimap)queryParams);
            String string = this.apiKey;
            Intrinsics.checkNotNull((Object)string);
            return new ClientOptions(httpClient, httpClient3, this.jsonMapper, this.clock, this.baseUrl, listMultimap, listMultimap2, this.responseValidation, this.maxRetries, string, null);
        }

        private static final void putAllHeaders$lambda$9$lambda$8(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final void replaceAllHeaders$lambda$13$lambda$12(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final void putAllQueryParams$lambda$20$lambda$19(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final void replaceAllQueryParams$lambda$24$lambda$23(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final void build$lambda$34(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final void build$lambda$36(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/onebusaway/core/ClientOptions$Companion;", "", "()V", "PRODUCTION_URL", "", "builder", "Lorg/onebusaway/core/ClientOptions$Builder;", "fromEnv", "Lorg/onebusaway/core/ClientOptions;", "onebusaway-sdk-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        @JvmStatic
        @NotNull
        public final ClientOptions fromEnv() {
            return this.builder().fromEnv().build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

