/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.core.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.collect.ListMultimap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.onebusaway.core.handlers.StringHandler;
import org.onebusaway.core.http.HttpResponse;
import org.onebusaway.errors.BadRequestException;
import org.onebusaway.errors.InternalServerException;
import org.onebusaway.errors.NotFoundException;
import org.onebusaway.errors.OnebusawaySdkError;
import org.onebusaway.errors.OnebusawaySdkException;
import org.onebusaway.errors.PermissionDeniedException;
import org.onebusaway.errors.RateLimitException;
import org.onebusaway.errors.UnauthorizedException;
import org.onebusaway.errors.UnexpectedStatusCodeException;
import org.onebusaway.errors.UnprocessableEntityException;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0006H\u0002\u001a,\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\b0\u0001\"\u0004\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\u00012\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u00a8\u0006\t"}, d2={"errorHandler", "Lorg/onebusaway/core/http/HttpResponse$Handler;", "Lorg/onebusaway/errors/OnebusawaySdkError;", "jsonMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "buffered", "Lorg/onebusaway/core/http/HttpResponse;", "withErrorHandler", "T", "onebusaway-sdk-java-core"})
@JvmName(name="ErrorHandler")
@SourceDebugExtension(value={"SMAP\nErrorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorHandler.kt\norg/onebusaway/core/handlers/ErrorHandler\n+ 2 JsonHandler.kt\norg/onebusaway/core/handlers/JsonHandler\n*L\n1#1,128:1\n13#2,9:129\n*S KotlinDebug\n*F\n+ 1 ErrorHandler.kt\norg/onebusaway/core/handlers/ErrorHandler\n*L\n23#1:129,9\n*E\n"})
public final class ErrorHandler {
    public static final /* synthetic */ HttpResponse.Handler errorHandler(JsonMapper jsonMapper) {
        Intrinsics.checkNotNullParameter((Object)jsonMapper, (String)"jsonMapper");
        boolean $i$f$jsonHandler = false;
        HttpResponse.Handler handler = new HttpResponse.Handler<OnebusawaySdkError>(jsonMapper){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public OnebusawaySdkError handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<OnebusawaySdkError>(){});
                }
                catch (Exception e) {
                    throw new OnebusawaySdkException("Error reading response", e);
                }
            }
        };
        return new HttpResponse.Handler<OnebusawaySdkError>((HttpResponse.Handler<OnebusawaySdkError>)handler){
            final /* synthetic */ HttpResponse.Handler<OnebusawaySdkError> $handler;
            {
                this.$handler = $handler;
            }

            @NotNull
            public OnebusawaySdkError handle(@NotNull HttpResponse response) {
                OnebusawaySdkError onebusawaySdkError;
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    onebusawaySdkError = this.$handler.handle(response);
                }
                catch (Exception e) {
                    onebusawaySdkError = OnebusawaySdkError.Companion.builder().build();
                }
                return onebusawaySdkError;
            }
        };
    }

    public static final /* synthetic */ HttpResponse.Handler withErrorHandler(HttpResponse.Handler $this$withErrorHandler, HttpResponse.Handler errorHandler2) {
        Intrinsics.checkNotNullParameter((Object)$this$withErrorHandler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)errorHandler2, (String)"errorHandler");
        return new HttpResponse.Handler<T>($this$withErrorHandler, errorHandler2){
            final /* synthetic */ HttpResponse.Handler<T> $this_withErrorHandler;
            final /* synthetic */ HttpResponse.Handler<OnebusawaySdkError> $errorHandler;
            {
                this.$this_withErrorHandler = $receiver;
                this.$errorHandler = $errorHandler;
            }

            public T handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                int statusCode = response.statusCode();
                boolean bl = 200 <= statusCode ? statusCode < 300 : false;
                if (bl) {
                    return this.$this_withErrorHandler.handle(response);
                }
                if (statusCode == 400) {
                    HttpResponse buffered2 = ErrorHandler.access$buffered(response);
                    throw new BadRequestException(buffered2.headers(), (String)StringHandler.stringHandler().handle(buffered2), this.$errorHandler.handle(buffered2));
                }
                if (statusCode == 401) {
                    HttpResponse buffered3 = ErrorHandler.access$buffered(response);
                    throw new UnauthorizedException(buffered3.headers(), (String)StringHandler.stringHandler().handle(buffered3), this.$errorHandler.handle(buffered3));
                }
                if (statusCode == 403) {
                    HttpResponse buffered4 = ErrorHandler.access$buffered(response);
                    throw new PermissionDeniedException(buffered4.headers(), (String)StringHandler.stringHandler().handle(buffered4), this.$errorHandler.handle(buffered4));
                }
                if (statusCode == 404) {
                    HttpResponse buffered5 = ErrorHandler.access$buffered(response);
                    throw new NotFoundException(buffered5.headers(), (String)StringHandler.stringHandler().handle(buffered5), this.$errorHandler.handle(buffered5));
                }
                if (statusCode == 422) {
                    HttpResponse buffered6 = ErrorHandler.access$buffered(response);
                    throw new UnprocessableEntityException(buffered6.headers(), (String)StringHandler.stringHandler().handle(buffered6), this.$errorHandler.handle(buffered6));
                }
                if (statusCode == 429) {
                    HttpResponse buffered7 = ErrorHandler.access$buffered(response);
                    throw new RateLimitException(buffered7.headers(), (String)StringHandler.stringHandler().handle(buffered7), this.$errorHandler.handle(buffered7));
                }
                boolean bl2 = 500 <= statusCode ? statusCode < 600 : false;
                if (bl2) {
                    HttpResponse buffered8 = ErrorHandler.access$buffered(response);
                    throw new InternalServerException(statusCode, buffered8.headers(), (String)StringHandler.stringHandler().handle(buffered8), this.$errorHandler.handle(buffered8));
                }
                HttpResponse buffered9 = ErrorHandler.access$buffered(response);
                throw new UnexpectedStatusCodeException(statusCode, buffered9.headers(), (String)StringHandler.stringHandler().handle(buffered9), this.$errorHandler.handle(buffered9));
            }
        };
    }

    private static final HttpResponse buffered(HttpResponse $this$buffered) {
        byte[] body = ByteStreamsKt.readBytes((InputStream)$this$buffered.body());
        return new HttpResponse($this$buffered, body){
            final /* synthetic */ HttpResponse $this_buffered;
            final /* synthetic */ byte[] $body;
            {
                this.$this_buffered = $receiver;
                this.$body = $body;
            }

            public int statusCode() {
                return this.$this_buffered.statusCode();
            }

            @NotNull
            public ListMultimap<String, String> headers() {
                return this.$this_buffered.headers();
            }

            @NotNull
            public InputStream body() {
                return new ByteArrayInputStream(this.$body);
            }

            public void close() {
                this.$this_buffered.close();
            }
        };
    }

    public static final /* synthetic */ HttpResponse access$buffered(HttpResponse $receiver) {
        return ErrorHandler.buffered($receiver);
    }
}

