/*
 * Decompiled with CFR 0.152.
 */
package org.snowflake.plus.core;

import com.google.common.base.Preconditions;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snowflake.plus.core.Result;
import org.snowflake.plus.core.SnowflakeIDGen;
import org.snowflake.plus.core.SnowflakeZookeeperHolder;
import org.snowflake.plus.core.Status;
import org.snowflake.plus.core.Utils;

public class SnowflakeIDGenImpl
implements SnowflakeIDGen {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeIDGenImpl.class);
    private final long twepoch = 1563408000000L;
    private final long workerIdBits = 10L;
    private final long maxWorkerId = 1023L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private long workerId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private boolean initFlag = false;
    private static final Random RANDOM = new Random();

    public SnowflakeIDGenImpl(String name, String zkAddress, Integer port, Integer workerId) {
        SnowflakeZookeeperHolder holder = new SnowflakeZookeeperHolder(name, Utils.getIp(), String.valueOf(port), zkAddress);
        boolean initFlag = holder.init();
        if (initFlag) {
            this.initFlag = true;
            this.workerId = holder.getWorkerID();
            log.info("START SUCCESS USE ZK WORKERID-{}", (Object)this.workerId);
        } else {
            this.workerId = workerId.intValue();
            if (workerId == 0) {
                log.info("START SUCCESS USE DEFAULT WORKERID-{}", (Object)this.workerId);
            } else {
                log.info("START SUCCESS USE CONFIG WORKERID-{}", (Object)this.workerId);
            }
        }
        Preconditions.checkArgument((this.workerId >= 0L && this.workerId <= 1023L ? 1 : 0) != 0, (Object)"workerID must gte 0 and lte 1023");
    }

    @Override
    public boolean init() {
        return this.initFlag;
    }

    @Override
    public synchronized Result get() {
        long timestamp;
        block8: {
            timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp) {
                long offset = this.lastTimestamp - timestamp;
                if (offset <= 5L) {
                    try {
                        this.wait(offset << 1);
                        timestamp = this.timeGen();
                        if (timestamp < this.lastTimestamp) {
                            return new Result(-1L, Status.EXCEPTION);
                        }
                        break block8;
                    }
                    catch (InterruptedException e) {
                        log.error("wait interrupted");
                        return new Result(-2L, Status.EXCEPTION);
                    }
                }
                return new Result(-3L, Status.EXCEPTION);
            }
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                this.sequence = RANDOM.nextInt(100);
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = RANDOM.nextInt(100);
        }
        this.lastTimestamp = timestamp;
        long id = timestamp - 1563408000000L << 22 | this.workerId << 12 | this.sequence;
        return new Result(id, Status.SUCCESS);
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    public long getWorkerId() {
        return this.workerId;
    }
}

