/*
 * Decompiled with CFR 0.152.
 */
package org.snowflake.plus.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.retry.RetryUntilElapsed;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snowflake.plus.core.exception.CheckLastTimeException;

public class SnowflakeZookeeperHolder {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeZookeeperHolder.class);
    private String zkAddressNode = null;
    private String listenAddress;
    private int workerID;
    private String prefixZkPath;
    private String propPath;
    private String pathForever;
    private String name;
    private String ip;
    private String port;
    private String connectionString;
    private long lastUpdateTime;

    public SnowflakeZookeeperHolder(String name, String ip, String port, String connectionString) {
        this.name = name;
        this.ip = ip;
        this.port = port;
        this.listenAddress = ip + ":" + port;
        this.connectionString = connectionString;
        this.prefixZkPath = "/snowflake/" + name;
        this.propPath = System.getProperty("java.io.tmpdir") + File.separator + name + "/snowflake-conf/{port}/workerID.properties";
        this.pathForever = this.prefixZkPath + "/forever";
    }

    public boolean init() {
        try {
            String[] nodeKey;
            CuratorFramework curator = this.createWithOptions(this.connectionString, (RetryPolicy)new RetryUntilElapsed(1000, 4), 10000, 6000);
            curator.start();
            Stat stat = (Stat)curator.checkExists().forPath(this.pathForever);
            if (stat == null) {
                this.zkAddressNode = this.createNode(curator);
                this.updateLocalWorkerID(this.workerID);
                this.ScheduledUploadData(curator, this.zkAddressNode);
                return true;
            }
            HashMap nodeMap = Maps.newHashMap();
            HashMap realNode = Maps.newHashMap();
            List keys = (List)curator.getChildren().forPath(this.pathForever);
            for (String key : keys) {
                nodeKey = key.split("-");
                realNode.put(nodeKey[0], key);
                nodeMap.put(nodeKey[0], Integer.parseInt(nodeKey[1]));
            }
            Integer workerId = (Integer)nodeMap.get(this.listenAddress);
            if (workerId != null) {
                this.zkAddressNode = this.pathForever + "/" + (String)realNode.get(this.listenAddress);
                this.workerID = workerId;
                if (!this.checkInitTimeStamp(curator, this.zkAddressNode)) {
                    throw new CheckLastTimeException("init timestamp check error,forever node timestamp gt this node time");
                }
                this.doService(curator);
                this.updateLocalWorkerID(this.workerID);
                log.info("[Old NODE]find forever node have this endpoint ip-{} port-{} workID-{} childNode and start SUCCESS", new Object[]{this.ip, this.port, this.workerID});
            } else {
                String newNode;
                this.zkAddressNode = newNode = this.createNode(curator);
                nodeKey = newNode.split("-");
                this.workerID = Integer.parseInt(nodeKey[1]);
                this.doService(curator);
                this.updateLocalWorkerID(this.workerID);
                log.info("[New NODE]can not find node on forever node that endpoint ip-{} port-{} workID-{},create own node on forever node and start SUCCESS ", new Object[]{this.ip, this.port, this.workerID});
            }
        }
        catch (Exception e) {
            log.error("Start node ERROR {}", (Object)e.getMessage(), (Object)e);
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(new File(this.propPath.replace("{port}", this.port + ""))));
                this.workerID = Integer.valueOf(properties.getProperty("workerID"));
                log.warn("START FAILED ,use local node file properties workerID-{}", (Object)this.workerID);
            }
            catch (Exception e1) {
                log.error("Read file error ", (Throwable)e1);
                return false;
            }
        }
        return true;
    }

    private void doService(CuratorFramework curator) {
        this.ScheduledUploadData(curator, this.zkAddressNode);
    }

    private void ScheduledUploadData(CuratorFramework curator, String zkAddressNode) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("schedule-upload-time").build());
        executor.scheduleWithFixedDelay(() -> this.updateNewData(curator, zkAddressNode), 1L, 3L, TimeUnit.SECONDS);
    }

    private boolean checkInitTimeStamp(CuratorFramework curator, String zkAddressNode) throws Exception {
        byte[] bytes = (byte[])curator.getData().forPath(zkAddressNode);
        Endpoint endPoint = this.deBuildData(new String(bytes));
        return endPoint.getTimestamp() <= System.currentTimeMillis();
    }

    private String createNode(CuratorFramework curator) throws Exception {
        try {
            return (String)((ACLBackgroundPathAndBytesable)curator.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(this.pathForever + "/" + this.listenAddress + "-", this.buildData().getBytes());
        }
        catch (Exception e) {
            log.error("create node error msg {} ", (Object)e.getMessage());
            throw e;
        }
    }

    private void updateNewData(CuratorFramework curator, String path) {
        try {
            if (System.currentTimeMillis() < this.lastUpdateTime) {
                return;
            }
            curator.setData().forPath(path, this.buildData().getBytes());
            this.lastUpdateTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            log.info("update init data error path is {} error is {}", (Object)path, (Object)e);
        }
    }

    private String buildData() throws JsonProcessingException {
        Endpoint endpoint = new Endpoint(this.ip, this.port, System.currentTimeMillis());
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)endpoint);
        return json;
    }

    private Endpoint deBuildData(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Endpoint endpoint = (Endpoint)mapper.readValue(json, Endpoint.class);
        return endpoint;
    }

    private void updateLocalWorkerID(int workerID) {
        File snowflakeConfFile = new File(this.propPath.replace("{port}", this.port));
        boolean exists = snowflakeConfFile.exists();
        log.info("file exists status is {}", (Object)exists);
        if (exists) {
            try {
                FileUtils.writeStringToFile((File)snowflakeConfFile, (String)("workerID=" + workerID), (boolean)false);
                log.info("update file cache workerID is {}", (Object)workerID);
            }
            catch (IOException e) {
                log.error("update file cache error ", (Throwable)e);
            }
        } else {
            try {
                boolean mkdirs = snowflakeConfFile.getParentFile().mkdirs();
                log.info("init local file cache create parent dis status is {}, worker id is {}", (Object)mkdirs, (Object)workerID);
                if (mkdirs) {
                    if (snowflakeConfFile.createNewFile()) {
                        FileUtils.writeStringToFile((File)snowflakeConfFile, (String)("workerID=" + workerID), (boolean)false);
                        log.info("local file cache workerID is {}", (Object)workerID);
                    }
                } else {
                    log.warn("create parent dir error===");
                }
            }
            catch (IOException e) {
                log.warn("create workerID conf file error", (Throwable)e);
            }
        }
    }

    private CuratorFramework createWithOptions(String connectionString, RetryPolicy retryPolicy, int connectionTimeoutMs, int sessionTimeoutMs) {
        return CuratorFrameworkFactory.builder().connectString(connectionString).retryPolicy(retryPolicy).connectionTimeoutMs(connectionTimeoutMs).sessionTimeoutMs(sessionTimeoutMs).build();
    }

    public String getZkAddressNode() {
        return this.zkAddressNode;
    }

    public void setZkAddressNode(String zkAddressNode) {
        this.zkAddressNode = zkAddressNode;
    }

    public String getListenAddress() {
        return this.listenAddress;
    }

    public void setListenAddress(String listenAddress) {
        this.listenAddress = listenAddress;
    }

    public int getWorkerID() {
        return this.workerID;
    }

    public void setWorkerID(int workerID) {
        this.workerID = workerID;
    }

    static class Endpoint {
        private String ip;
        private String port;
        private long timestamp;

        public Endpoint() {
        }

        public Endpoint(String ip, String port, long timestamp) {
            this.ip = ip;
            this.port = port;
            this.timestamp = timestamp;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

