/*
 * Decompiled with CFR 0.152.
 */
package org.snowflake.plus.core;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static String getIp() {
        String ip;
        try {
            List<String> ipList = Utils.getHostAddress(null);
            ip = !ipList.isEmpty() ? ipList.get(0) : "";
        }
        catch (Exception ex) {
            ip = "";
            log.warn("Utils get IP warn", (Throwable)ex);
        }
        return ip;
    }

    public static String getIp(String interfaceName) {
        String ip;
        interfaceName = interfaceName.trim();
        try {
            List<String> ipList = Utils.getHostAddress(interfaceName);
            ip = !ipList.isEmpty() ? ipList.get(0) : "";
        }
        catch (Exception ex) {
            ip = "";
            log.warn("Utils get IP warn", (Throwable)ex);
        }
        return ip;
    }

    private static List<String> getHostAddress(String interfaceName) throws SocketException {
        ArrayList<String> ipList = new ArrayList<String>(5);
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface ni = interfaces.nextElement();
            Enumeration<InetAddress> allAddress = ni.getInetAddresses();
            while (allAddress.hasMoreElements()) {
                InetAddress address = allAddress.nextElement();
                if (address.isLoopbackAddress() || address instanceof Inet6Address) continue;
                String hostAddress = address.getHostAddress();
                if (null == interfaceName) {
                    ipList.add(hostAddress);
                    continue;
                }
                if (!interfaceName.equals(ni.getDisplayName())) continue;
                ipList.add(hostAddress);
            }
        }
        return ipList;
    }
}

