/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.testing.EqualsTester;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.cluster.Leader;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.NodeId;

public class LeadershipEventTest {
    private final NodeId node1 = new NodeId("1");
    private final NodeId node2 = new NodeId("2");
    private final Leadership lead1 = new Leadership("topic1", new Leader(this.node1, 1L, 2L), Arrays.asList(this.node1));
    private final Leadership lead2 = new Leadership("topic1", new Leader(this.node1, 1L, 2L), Arrays.asList(this.node1, this.node2));
    private final Leadership lead3 = new Leadership("topic1", new Leader(this.node2, 1L, 2L), Arrays.asList(this.node2));
    private final LeadershipEvent event1 = new LeadershipEvent(LeadershipEvent.Type.LEADER_CHANGED, this.lead1);
    private final long time = System.currentTimeMillis();
    private final LeadershipEvent event2 = new LeadershipEvent(LeadershipEvent.Type.CANDIDATES_CHANGED, this.lead2, this.time);
    private final LeadershipEvent sameAsEvent2 = new LeadershipEvent(LeadershipEvent.Type.CANDIDATES_CHANGED, this.lead2, this.time);
    private final LeadershipEvent event3 = new LeadershipEvent(LeadershipEvent.Type.LEADER_CHANGED, this.lead2);
    private final LeadershipEvent event4 = new LeadershipEvent(LeadershipEvent.Type.LEADER_AND_CANDIDATES_CHANGED, this.lead3);

    @Test
    public void checkEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.event1}).addEqualityGroup(new Object[]{this.event2, this.sameAsEvent2}).addEqualityGroup(new Object[]{this.event3}).addEqualityGroup(new Object[]{this.event4}).testEquals();
    }

    @Test
    public void checkConstruction() {
        Assert.assertThat((Object)((LeadershipEvent.Type)this.event1.type()), (Matcher)Matchers.is((Object)LeadershipEvent.Type.LEADER_CHANGED));
        Assert.assertThat((Object)((Leadership)this.event1.subject()), (Matcher)Matchers.is((Object)this.lead1));
        Assert.assertThat((Object)this.event2.time(), (Matcher)Matchers.is((Object)this.time));
        Assert.assertThat((Object)((LeadershipEvent.Type)this.event2.type()), (Matcher)Matchers.is((Object)LeadershipEvent.Type.CANDIDATES_CHANGED));
        Assert.assertThat((Object)((Leadership)this.event2.subject()), (Matcher)Matchers.is((Object)this.lead2));
    }
}

