/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.event;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.event.DefaultEventSinkRegistry;
import org.onosproject.event.EventSink;
import org.onosproject.event.TestEvent;

public class DefaultEventSinkRegistryTest {
    private DefaultEventSinkRegistry registry;

    @Before
    public void setUp() {
        this.registry = new DefaultEventSinkRegistry();
    }

    @Test
    public void basics() {
        FooSink fooSink = new FooSink();
        BarSink barSink = new BarSink();
        this.registry.addSink(FooEvent.class, (EventSink)fooSink);
        this.registry.addSink(BarEvent.class, (EventSink)barSink);
        Assert.assertEquals((String)"incorrect sink count", (long)2L, (long)this.registry.getSinks().size());
        Assert.assertEquals((String)"incorrect sink", (Object)fooSink, (Object)this.registry.getSink(FooEvent.class));
        Assert.assertEquals((String)"incorrect sink", (Object)barSink, (Object)this.registry.getSink(BarEvent.class));
        this.registry.removeSink(FooEvent.class);
        Assert.assertNull((String)"incorrect sink", (Object)this.registry.getSink(FooEvent.class));
        Assert.assertEquals((String)"incorrect sink", (Object)barSink, (Object)this.registry.getSink(BarEvent.class));
    }

    private static class BarSink
    implements EventSink<BarEvent> {
        private BarSink() {
        }

        public void process(BarEvent event) {
        }
    }

    private static class FooSink
    implements EventSink<FooEvent> {
        private FooSink() {
        }

        public void process(FooEvent event) {
        }
    }

    private static class BarEvent
    extends TestEvent {
        public BarEvent(String subject) {
            super(TestEvent.Type.BAR, subject);
        }
    }

    private static class FooEvent
    extends TestEvent {
        public FooEvent(String subject) {
            super(TestEvent.Type.FOO, subject);
        }
    }
}

