/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mastership;

import com.google.common.collect.ImmutableMap;
import com.google.common.testing.EqualsTester;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.cluster.NodeId;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipInfo;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;

public class MastershipEventTest {
    private final long time = System.currentTimeMillis();
    private final DeviceId deviceId1 = DeviceId.deviceId((String)"foo:bar");
    private final DeviceId deviceId2 = DeviceId.deviceId((String)"bar:baz");
    private final NodeId node1 = new NodeId("1");
    private final NodeId node2 = new NodeId("2");
    private final MastershipInfo mastershipInfo1 = new MastershipInfo(1L, Optional.of(this.node1), ImmutableMap.builder().put((Object)this.node1, (Object)MastershipRole.MASTER).put((Object)this.node2, (Object)MastershipRole.STANDBY).build());
    private final MastershipInfo mastershipInfo2 = new MastershipInfo(2L, Optional.of(this.node1), ImmutableMap.builder().put((Object)this.node2, (Object)MastershipRole.MASTER).put((Object)this.node1, (Object)MastershipRole.STANDBY).build());
    private final MastershipEvent event1 = new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, this.deviceId1, this.mastershipInfo1);
    private final MastershipEvent event2 = new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, this.deviceId1, this.mastershipInfo1);
    private final MastershipEvent event3 = new MastershipEvent(MastershipEvent.Type.SUSPENDED, this.deviceId1, this.mastershipInfo1);
    private final MastershipEvent event4 = new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, this.deviceId1, this.mastershipInfo2, this.time);
    private final MastershipEvent sameAsEvent4 = new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, this.deviceId1, this.mastershipInfo2, this.time);
    private final MastershipEvent event5 = new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, this.deviceId2, this.mastershipInfo1);

    @Test
    public void checkEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.event1}).addEqualityGroup(new Object[]{this.event2}).addEqualityGroup(new Object[]{this.event3}).addEqualityGroup(new Object[]{this.event4, this.sameAsEvent4}).addEqualityGroup(new Object[]{this.event5}).testEquals();
    }

    @Test
    public void checkConstruction() {
        Assert.assertThat((Object)((MastershipEvent.Type)this.event1.type()), (Matcher)Matchers.is((Object)MastershipEvent.Type.BACKUPS_CHANGED));
        Assert.assertThat((Object)((DeviceId)this.event1.subject()), (Matcher)Matchers.is((Object)this.deviceId1));
        Assert.assertThat((Object)this.event1.mastershipInfo(), (Matcher)Matchers.is((Object)this.mastershipInfo1));
        Assert.assertThat((Object)this.event4.time(), (Matcher)Matchers.is((Object)this.time));
        Assert.assertThat((Object)((MastershipEvent.Type)this.event4.type()), (Matcher)Matchers.is((Object)MastershipEvent.Type.MASTER_CHANGED));
        Assert.assertThat((Object)((DeviceId)this.event4.subject()), (Matcher)Matchers.is((Object)this.deviceId1));
        Assert.assertThat((Object)this.event4.mastershipInfo(), (Matcher)Matchers.is((Object)this.mastershipInfo2));
    }
}

