/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.testing.EqualsTester;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;

public class DefaultPortTest {
    private static final ProviderId PID = new ProviderId("of", "foo");
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:foo");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:bar");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);
    private static final long SP1 = 1000000L;

    @Test
    public void testEquality() {
        DefaultDevice device = new DefaultDevice(PID, DID1, Device.Type.SWITCH, "m", "h", "s", "n", new ChassisId(), new Annotations[0]);
        DefaultPort p1 = new DefaultPort((Element)device, PortNumber.portNumber((long)1L), true, Port.Type.COPPER, 1000000L, new Annotations[0]);
        DefaultPort p2 = new DefaultPort((Element)device, PortNumber.portNumber((long)1L), true, Port.Type.COPPER, 1000000L, new Annotations[0]);
        DefaultPort p3 = new DefaultPort((Element)device, PortNumber.portNumber((long)2L), true, Port.Type.FIBER, 1000000L, new Annotations[0]);
        DefaultPort p4 = new DefaultPort((Element)device, PortNumber.portNumber((long)2L), true, Port.Type.FIBER, 1000000L, new Annotations[0]);
        DefaultPort p5 = new DefaultPort((Element)device, PortNumber.portNumber((long)1L), false, new Annotations[0]);
        new EqualsTester().addEqualityGroup(new Object[]{p1, p2}).addEqualityGroup(new Object[]{p3, p4}).addEqualityGroup(new Object[]{p5}).testEquals();
    }

    @Test
    public void basics() {
        DefaultDevice device = new DefaultDevice(PID, DID1, Device.Type.SWITCH, "m", "h", "s", "n", new ChassisId(), new Annotations[0]);
        DefaultPort port = new DefaultPort((Element)device, PortNumber.portNumber((long)1L), true, Port.Type.FIBER, 1000000L, new Annotations[0]);
        Assert.assertEquals((String)"incorrect element", (Object)device, (Object)port.element());
        Assert.assertEquals((String)"incorrect number", (Object)PortNumber.portNumber((long)1L), (Object)port.number());
        Assert.assertEquals((String)"incorrect state", (Object)true, (Object)port.isEnabled());
        Assert.assertEquals((String)"incorrect speed", (long)1000000L, (long)port.portSpeed());
        Assert.assertEquals((String)"incorrect type", (Object)Port.Type.FIBER, (Object)port.type());
    }
}

