/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.testing.EqualsTester;
import com.spotify.hamcrest.optional.OptionalMatchers;
import java.util.EnumSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.util.Bandwidth;
import org.onosproject.net.behaviour.DefaultQueueDescription;
import org.onosproject.net.behaviour.QueueDescription;
import org.onosproject.net.behaviour.QueueId;

public class DefaultQueueDescriptionTest {
    private static final Bandwidth MAX_BANDWIDTH_1 = Bandwidth.bps((long)2L);
    private static final Bandwidth MIN_BANDWIDTH_1 = Bandwidth.bps((long)1L);
    private static final QueueId QUEUE_ID1 = QueueId.queueId((String)"QUEUE 1");
    private static final Bandwidth MAX_BANDWIDTH_2 = Bandwidth.bps((long)12L);
    private static final Bandwidth MIN_BANDWIDTH_2 = Bandwidth.bps((long)11L);
    private static final QueueId QUEUE_ID2 = QueueId.queueId((String)"QUEUE 2");
    private QueueDescription queueDescription1 = DefaultQueueDescription.builder().burst(Long.valueOf(1L)).dscp(Integer.valueOf(11)).maxRate(MAX_BANDWIDTH_1).minRate(MIN_BANDWIDTH_1).priority(Long.valueOf(1L)).type(EnumSet.of(QueueDescription.Type.MAX)).queueId(QUEUE_ID1).build();
    private QueueDescription sameAsQueueDescription1 = DefaultQueueDescription.builder().burst(Long.valueOf(1L)).dscp(Integer.valueOf(11)).maxRate(MAX_BANDWIDTH_1).minRate(MIN_BANDWIDTH_1).priority(Long.valueOf(1L)).type(EnumSet.of(QueueDescription.Type.MAX)).queueId(QUEUE_ID1).build();
    private QueueDescription queueDescription2 = DefaultQueueDescription.builder().burst(Long.valueOf(2L)).dscp(Integer.valueOf(12)).maxRate(MAX_BANDWIDTH_2).minRate(MIN_BANDWIDTH_2).priority(Long.valueOf(1L)).type(EnumSet.of(QueueDescription.Type.MAX)).queueId(QUEUE_ID2).build();

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.queueDescription1.burst(), (Matcher)OptionalMatchers.optionalWithValue((Matcher)Matchers.is((Object)1L)));
        MatcherAssert.assertThat((Object)this.queueDescription1.dscp(), (Matcher)OptionalMatchers.optionalWithValue((Matcher)Matchers.is((Object)11)));
        MatcherAssert.assertThat((Object)this.queueDescription1.maxRate(), (Matcher)OptionalMatchers.optionalWithValue((Matcher)Matchers.is((Object)MAX_BANDWIDTH_1)));
        MatcherAssert.assertThat((Object)this.queueDescription1.minRate(), (Matcher)OptionalMatchers.optionalWithValue((Matcher)Matchers.is((Object)MIN_BANDWIDTH_1)));
        MatcherAssert.assertThat((Object)this.queueDescription1.priority(), (Matcher)OptionalMatchers.optionalWithValue((Matcher)Matchers.is((Object)1L)));
        MatcherAssert.assertThat((Object)this.queueDescription1.queueId(), (Matcher)Matchers.is((Object)QUEUE_ID1));
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.queueDescription1, this.sameAsQueueDescription1}).addEqualityGroup(new Object[]{this.queueDescription2}).testEquals();
    }
}

