/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.protection;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.DeviceId;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointDescription;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointState;
import org.onosproject.net.behaviour.protection.TransportEndpointDescription;
import org.onosproject.net.behaviour.protection.TransportEndpointId;
import org.onosproject.net.behaviour.protection.TransportEndpointState;

public class ProtectedTransportEndpointStateTest {
    private List<TransportEndpointDescription> paths = ImmutableList.of();
    private DeviceId peer = NetTestTools.did("d1");
    private String fingerprint = "aaa";
    private TransportEndpointDescription description = TransportEndpointDescription.builder().withEnabled(true).withOutput(new FilteredConnectPoint(NetTestTools.connectPoint("xxx", 1))).build();
    private ProtectedTransportEndpointDescription protectedDescription = ProtectedTransportEndpointDescription.buildDescription(this.paths, (DeviceId)this.peer, (String)this.fingerprint);
    private TransportEndpointState state1 = TransportEndpointState.builder().withId(TransportEndpointId.of((String)"1")).withDescription(this.description).withLive(true).build();
    private List<TransportEndpointState> pathStates = ImmutableList.of((Object)this.state1);

    @Test
    public void testConstruction() {
        ProtectedTransportEndpointState state = ProtectedTransportEndpointState.builder().withActivePathIndex(0).withDescription(this.protectedDescription).withPathStates(this.pathStates).build();
        Assert.assertThat((Object)state, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)state.description(), (Matcher)Matchers.is((Object)this.protectedDescription));
        Assert.assertThat((Object)state.pathStates(), (Matcher)Matchers.contains((Object[])new TransportEndpointState[]{this.state1}));
        Assert.assertThat((Object)state.workingPathIndex(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testToString() {
        ProtectedTransportEndpointState state1 = ProtectedTransportEndpointState.builder().withActivePathIndex(0).withDescription(this.protectedDescription).withPathStates(this.pathStates).build();
        ProtectedTransportEndpointState state2 = ProtectedTransportEndpointState.builder().copyFrom(state1).build();
        Assert.assertThat((Object)state1.toString(), (Matcher)Matchers.is((Object)state2.toString()));
    }
}

