/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.trafficcontrol;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.onosproject.TestApplicationId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.trafficcontrol.DefaultPolicer;
import org.onosproject.net.behaviour.trafficcontrol.DefaultTokenBucket;
import org.onosproject.net.behaviour.trafficcontrol.Policer;
import org.onosproject.net.behaviour.trafficcontrol.PolicerId;
import org.onosproject.net.behaviour.trafficcontrol.TokenBucket;

public class PolicerTest {
    private static final ApplicationId FOO_APP_ID = new TestApplicationId("foo");
    private static final String SDID1 = "of:00000000000001";
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:00000000000001");
    private static final String OF_SCHEME = "of";
    private static final String SID1 = "of:" + Integer.toHexString(1);
    private static final PolicerId ID1 = PolicerId.policerId((String)SID1);
    private static final String SID2 = "of:" + Integer.toHexString(2);
    private static final PolicerId ID2 = PolicerId.policerId((String)SID2);
    private static final String SID3 = "of:" + Integer.toHexString(3);
    private static final PolicerId ID3 = PolicerId.policerId((String)SID3);
    private static final String SID4 = "of:" + Integer.toHexString(4);
    private static final PolicerId ID4 = PolicerId.policerId((String)SID4);
    private static final String SID5 = "of:" + Integer.toHexString(5);
    private static final PolicerId ID5 = PolicerId.policerId((String)SID5);
    private static final String SID6 = "of:" + Integer.toHexString(6);
    private static final PolicerId ID6 = PolicerId.policerId((String)SID6);
    private static final String SID7 = "of:" + Integer.toHexString(7);
    private static final PolicerId ID7 = PolicerId.policerId((String)SID7);
    private static final String SID8 = "of:" + Integer.toHexString(8);
    private static final PolicerId ID8 = PolicerId.policerId((String)SID8);
    private static final String SID9 = "of:" + Integer.toHexString(9);
    private static final PolicerId ID9 = PolicerId.policerId((String)SID9);
    @Rule
    public ExpectedException exceptionNullParam = ExpectedException.none();
    @Rule
    public ExpectedException exceptionNoTokenBuckets = ExpectedException.none();

    @Test
    public void testBlockCreation() {
        TokenBucket tokenBucket = DefaultTokenBucket.builder().withBurstSize(0L).withAction(TokenBucket.Action.DROP).withType(TokenBucket.Type.COMMITTED).build();
        Policer policer = DefaultPolicer.builder().forDeviceId(DID1).fromApp(FOO_APP_ID).withId(ID1).withTokenBuckets((Collection)ImmutableList.of((Object)tokenBucket)).build();
        Assert.assertThat((Object)policer.deviceId(), (Matcher)Matchers.is((Object)DID1));
        Assert.assertThat((Object)policer.applicationId(), (Matcher)Matchers.is((Object)FOO_APP_ID));
        Assert.assertThat((Object)policer.policerId(), (Matcher)Matchers.is((Object)ID1));
        Assert.assertFalse((boolean)policer.isColorAware());
        Assert.assertThat((Object)policer.unit(), (Matcher)Matchers.is((Object)Policer.Unit.MB_PER_SEC));
        Assert.assertThat((Object)policer.tokenBuckets().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertTrue((boolean)policer.tokenBuckets().contains(tokenBucket));
    }

    @Test
    public void testDropCreation() {
        TokenBucket tokenBucket = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DROP).withType(TokenBucket.Type.COMMITTED).build();
        Policer policer = DefaultPolicer.builder().forDeviceId(DID1).fromApp(FOO_APP_ID).withId(ID2).withTokenBuckets((Collection)ImmutableList.of((Object)tokenBucket)).build();
        Assert.assertThat((Object)policer.deviceId(), (Matcher)Matchers.is((Object)DID1));
        Assert.assertThat((Object)policer.applicationId(), (Matcher)Matchers.is((Object)FOO_APP_ID));
        Assert.assertThat((Object)policer.policerId(), (Matcher)Matchers.is((Object)ID2));
        Assert.assertFalse((boolean)policer.isColorAware());
        Assert.assertThat((Object)policer.unit(), (Matcher)Matchers.is((Object)Policer.Unit.MB_PER_SEC));
        Assert.assertThat((Object)policer.tokenBuckets().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertTrue((boolean)policer.tokenBuckets().contains(tokenBucket));
    }

    @Test
    public void testMarkCreation() {
        TokenBucket tokenBucket = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DSCP_PRECEDENCE).withDscp((short)2).withType(TokenBucket.Type.COMMITTED).build();
        Policer policer = DefaultPolicer.builder().forDeviceId(DID1).fromApp(FOO_APP_ID).withId(ID3).withTokenBuckets((Collection)ImmutableList.of((Object)tokenBucket)).build();
        Assert.assertThat((Object)policer.deviceId(), (Matcher)Matchers.is((Object)DID1));
        Assert.assertThat((Object)policer.applicationId(), (Matcher)Matchers.is((Object)FOO_APP_ID));
        Assert.assertThat((Object)policer.policerId(), (Matcher)Matchers.is((Object)ID3));
        Assert.assertFalse((boolean)policer.isColorAware());
        Assert.assertThat((Object)policer.unit(), (Matcher)Matchers.is((Object)Policer.Unit.MB_PER_SEC));
        Assert.assertThat((Object)policer.tokenBuckets().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertTrue((boolean)policer.tokenBuckets().contains(tokenBucket));
    }

    @Test
    public void testSingleRateThreeColors() {
        TokenBucket crTokenBucket = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DSCP_PRECEDENCE).withDscp((short)2).withType(TokenBucket.Type.COMMITTED).build();
        TokenBucket erTokenBucket = DefaultTokenBucket.builder().withRate(1L).withBurstSize(6000L).withAction(TokenBucket.Action.DROP).withType(TokenBucket.Type.EXCESS).build();
        Policer policer = DefaultPolicer.builder().forDeviceId(DID1).fromApp(FOO_APP_ID).withId(ID4).withTokenBuckets((Collection)ImmutableList.of((Object)crTokenBucket, (Object)erTokenBucket)).build();
        Assert.assertThat((Object)policer.deviceId(), (Matcher)Matchers.is((Object)DID1));
        Assert.assertThat((Object)policer.applicationId(), (Matcher)Matchers.is((Object)FOO_APP_ID));
        Assert.assertThat((Object)policer.policerId(), (Matcher)Matchers.is((Object)ID4));
        Assert.assertFalse((boolean)policer.isColorAware());
        Assert.assertThat((Object)policer.unit(), (Matcher)Matchers.is((Object)Policer.Unit.MB_PER_SEC));
        Assert.assertThat((Object)policer.tokenBuckets().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertTrue((boolean)policer.tokenBuckets().contains(crTokenBucket));
        Assert.assertTrue((boolean)policer.tokenBuckets().contains(erTokenBucket));
    }

    @Test
    public void testTwoRatesThreeColors() {
        TokenBucket prTokenBucket = DefaultTokenBucket.builder().withRate(1250L).withBurstSize(15000L).withAction(TokenBucket.Action.DROP).withType(TokenBucket.Type.PEAK).build();
        TokenBucket crTokenBucket = DefaultTokenBucket.builder().withRate(125L).withAction(TokenBucket.Action.DSCP_CLASS).withDscp((short)10).withType(TokenBucket.Type.COMMITTED).build();
        Policer policer = DefaultPolicer.builder().forDeviceId(DID1).fromApp(FOO_APP_ID).withId(ID5).withUnit(Policer.Unit.KB_PER_SEC).withTokenBuckets((Collection)ImmutableList.of((Object)prTokenBucket, (Object)crTokenBucket)).build();
        Assert.assertThat((Object)policer.deviceId(), (Matcher)Matchers.is((Object)DID1));
        Assert.assertThat((Object)policer.applicationId(), (Matcher)Matchers.is((Object)FOO_APP_ID));
        Assert.assertThat((Object)policer.policerId(), (Matcher)Matchers.is((Object)ID5));
        Assert.assertFalse((boolean)policer.isColorAware());
        Assert.assertThat((Object)policer.unit(), (Matcher)Matchers.is((Object)Policer.Unit.KB_PER_SEC));
        Assert.assertThat((Object)policer.tokenBuckets().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertTrue((boolean)policer.tokenBuckets().contains(prTokenBucket));
        Assert.assertTrue((boolean)policer.tokenBuckets().contains(crTokenBucket));
    }

    @Test
    public void testNullParam() {
        this.exceptionNullParam.expect(NullPointerException.class);
        DefaultPolicer.builder().fromApp(FOO_APP_ID).withId(ID6).build();
    }

    @Test
    public void testNoTokenBuckets() {
        this.exceptionNoTokenBuckets.expect(IllegalArgumentException.class);
        DefaultPolicer.builder().fromApp(FOO_APP_ID).withId(ID7).forDeviceId(DID1).withTokenBuckets((Collection)ImmutableList.of()).build();
    }

    @Test
    public void testEqualilty() {
        TokenBucket blockTokenBucket = DefaultTokenBucket.builder().withBurstSize(0L).withAction(TokenBucket.Action.DROP).withType(TokenBucket.Type.COMMITTED).build();
        TokenBucket markTokenBucket = DefaultTokenBucket.builder().withBurstSize(0L).withAction(TokenBucket.Action.DSCP_CLASS).withDscp((short)10).withType(TokenBucket.Type.COMMITTED).build();
        Policer policerOne = DefaultPolicer.builder().forDeviceId(DID1).fromApp(FOO_APP_ID).withId(ID8).withTokenBuckets((Collection)ImmutableList.of((Object)blockTokenBucket)).build();
        Policer policerTwo = DefaultPolicer.builder().forDeviceId(DID1).fromApp(FOO_APP_ID).withId(ID9).withTokenBuckets((Collection)ImmutableList.of((Object)markTokenBucket)).build();
        Policer policerThree = DefaultPolicer.builder().forDeviceId(DID1).fromApp(FOO_APP_ID).withId(ID8).withTokenBuckets((Collection)ImmutableList.of((Object)blockTokenBucket)).build();
        Assert.assertEquals((Object)policerOne, (Object)policerThree);
        Assert.assertNotEquals((Object)policerOne, (Object)policerTwo);
        Assert.assertNotEquals((Object)policerThree, (Object)policerTwo);
    }
}

