/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.InvalidFieldException;
import org.onosproject.net.config.basics.AbstractConfigTest;
import org.onosproject.net.config.basics.BasicRegionConfig;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.topo.LayoutLocation;

public class BasicRegionConfigTest
extends AbstractConfigTest {
    private static final String REGION_JSON = "configs.regions.1.json";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String DEVICES = "devices";
    private static final String R1 = "r1";
    private static final String R2 = "r2";
    private static final String R3 = "r3";
    private static final String EUROPE = "Europe";
    private static final String PARIS = "Paris";
    private static final String AUSTRALIA = "Australia";
    private static final Set<DeviceId> R1_DEVS = ImmutableSet.of((Object)BasicRegionConfigTest.dstr("01"), (Object)BasicRegionConfigTest.dstr("02"), (Object)BasicRegionConfigTest.dstr("03"));
    private static final Set<DeviceId> R2_DEVS = ImmutableSet.of((Object)BasicRegionConfigTest.dstr("04"), (Object)BasicRegionConfigTest.dstr("05"), (Object)BasicRegionConfigTest.dstr("06"));
    private static final Set<DeviceId> R3_DEVS = ImmutableSet.of((Object)BasicRegionConfigTest.dstr("07"), (Object)BasicRegionConfigTest.dstr("08"), (Object)BasicRegionConfigTest.dstr("09"));
    private static final Set<DeviceId> ALT_DEVICES = ImmutableSet.of((Object)BasicRegionConfigTest.dstr("0a"), (Object)BasicRegionConfigTest.dstr("0b"), (Object)BasicRegionConfigTest.dstr("0c"));
    private JsonNode data;
    private BasicRegionConfig cfg;

    @Before
    public void setUp() {
        this.data = this.getTestJson(REGION_JSON);
    }

    private JsonNode getR(String key) {
        return this.data.get("regions").get(key).get("basic");
    }

    private void loadRegion(String rid) {
        JsonNode node = this.getR(rid);
        BasicRegionConfigTest.print("%nJSON loaded: %s", node);
        this.cfg = new BasicRegionConfig();
        this.cfg.init((Object)RegionId.regionId((String)rid), rid, node, this.mapper, this.delegate);
    }

    private void checkRegion(String expN, Region.Type expT, Set<DeviceId> expD) {
        BasicRegionConfigTest.print("   checking: %s", this.cfg);
        Assert.assertEquals((String)"wrong name", (Object)expN, (Object)this.cfg.name());
        Assert.assertEquals((String)"wrong type", (Object)expT, (Object)this.cfg.type());
        List devs = this.cfg.devices();
        if (expD == null) {
            Assert.assertNull((String)"unexp device list", (Object)devs);
        } else {
            Assert.assertNotNull((Object)devs);
            Assert.assertEquals((String)"wr.size", (long)expD.size(), (long)devs.size());
            for (DeviceId d : expD) {
                Assert.assertTrue((String)("missing dev: " + d), (boolean)devs.contains(d));
            }
        }
    }

    @Test
    public void region1Config() {
        this.loadRegion(R1);
        this.checkRegion(EUROPE, Region.Type.CONTINENT, R1_DEVS);
    }

    @Test
    public void region2Config() {
        this.loadRegion(R2);
        this.checkRegion(PARIS, Region.Type.METRO, R2_DEVS);
    }

    @Test
    public void region3Config() {
        this.loadRegion(R3);
        this.checkRegion(R3, null, R3_DEVS);
    }

    @Test
    public void modifyName() {
        this.loadRegion(R1);
        this.cfg.name(AUSTRALIA);
        this.checkRegion(AUSTRALIA, Region.Type.CONTINENT, R1_DEVS);
    }

    @Test
    public void clearName() {
        this.loadRegion(R1);
        this.checkRegion(EUROPE, Region.Type.CONTINENT, R1_DEVS);
        this.cfg.name(null);
        this.checkRegion(R1, Region.Type.CONTINENT, R1_DEVS);
    }

    @Test
    public void modifyType() {
        this.loadRegion(R2);
        this.cfg.type(Region.Type.CAMPUS);
        this.checkRegion(PARIS, Region.Type.CAMPUS, R2_DEVS);
    }

    @Test
    public void clearType() {
        this.loadRegion(R2);
        this.cfg.type(null);
        this.checkRegion(PARIS, null, R2_DEVS);
    }

    @Test
    public void modifyDevices() {
        this.loadRegion(R3);
        this.cfg.devices(ALT_DEVICES);
        this.checkRegion(R3, null, ALT_DEVICES);
    }

    @Test
    public void clearDevices() {
        this.loadRegion(R3);
        this.cfg.devices(null);
        this.checkRegion(R3, null, null);
    }

    @Test
    public void sampleValidConfig() {
        ObjectNode node = new AbstractConfigTest.TmpJson().props(NAME, TYPE).arrays(DEVICES).node();
        this.cfg = new BasicRegionConfig();
        this.cfg.init((Object)RegionId.regionId((String)R1), "basic", (JsonNode)node, this.mapper, this.delegate);
        Assert.assertTrue((String)("not valid: " + this.cfg), (boolean)this.cfg.isValid());
    }

    @Test(expected=InvalidFieldException.class)
    public void sampleInvalidConfig() {
        ObjectNode node = new AbstractConfigTest.TmpJson().props(NAME, TYPE, "foo").arrays(DEVICES).node();
        this.cfg = new BasicRegionConfig();
        this.cfg.init((Object)RegionId.regionId((String)R1), "basic", (JsonNode)node, this.mapper, this.delegate);
        this.cfg.isValid();
    }

    @Test
    public void testPeerLocMapping() {
        String peer1 = "peer1";
        String loc1 = LayoutLocation.Type.GRID.toString();
        double loc1Y = 22.0;
        double loc1X = 33.0;
        String peer2 = "peer2";
        String loc2 = LayoutLocation.Type.GEO.toString();
        double loc2Y = 222.0;
        double loc2X = 333.0;
        this.loadRegion(R2);
        this.cfg.addPeerLocMapping(peer1, loc1, Double.valueOf(loc1Y), Double.valueOf(loc1X));
        this.cfg.addPeerLocMapping(peer2, loc2, Double.valueOf(loc2Y), Double.valueOf(loc2X));
        List locs = this.cfg.getMappings();
        MatcherAssert.assertThat((Object)locs, (Matcher)Matchers.hasSize((int)2));
        LayoutLocation createdLoc1 = locs.stream().filter(loc -> loc.id().equals(peer1)).findFirst().orElse(null);
        LayoutLocation createdLoc2 = locs.stream().filter(loc -> loc.id().equals(peer2)).findFirst().orElse(null);
        MatcherAssert.assertThat((Object)createdLoc1, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)createdLoc2, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)createdLoc1.locType().toString(), (Matcher)Matchers.is((Object)loc1));
        MatcherAssert.assertThat((Object)createdLoc1.longOrX(), (Matcher)Matchers.is((Object)loc1X));
        MatcherAssert.assertThat((Object)createdLoc1.latOrY(), (Matcher)Matchers.is((Object)loc1Y));
        MatcherAssert.assertThat((Object)createdLoc2.locType().toString(), (Matcher)Matchers.is((Object)loc2));
        MatcherAssert.assertThat((Object)createdLoc2.longOrX(), (Matcher)Matchers.is((Object)loc2X));
        MatcherAssert.assertThat((Object)createdLoc2.latOrY(), (Matcher)Matchers.is((Object)loc2Y));
    }
}

