/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.config.InvalidFieldException;
import org.onosproject.net.config.basics.AbstractConfigTest;
import org.onosproject.net.config.basics.BasicUiTopoLayoutConfig;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.topo.UiTopoLayoutId;

public class BasicUiTopoLayoutConfigTest
extends AbstractConfigTest {
    private static final String LAYOUT_JSON = "configs.layouts.1.json";
    private static final String L_DEFAULT = "root";
    private static final String L1 = "l1";
    private static final String L2 = "l2";
    private static final String L3 = "l3";
    private static final RegionId R1 = RegionId.regionId((String)"r1");
    private static final RegionId R2 = RegionId.regionId((String)"r2");
    private static final RegionId R3 = RegionId.regionId((String)"r3");
    private static final String UK = "uk";
    private static final String UK_BRIGHTON = "uk-brighton";
    private static final String UK_LONDON = "uk-london";
    private static final String UK_LONDON_WEST = "uk-london-westminster";
    private static final RegionId NEW_REGION = RegionId.regionId((String)"new-region");
    private static final UiTopoLayoutId NEW_PARENT = UiTopoLayoutId.layoutId((String)"new-parent");
    private static final String NEW_MAP = "new-geomap";
    private static final String NEW_SPR = "new-sprites";
    private JsonNode data;
    private BasicUiTopoLayoutConfig cfg;

    @Before
    public void setUp() {
        this.data = this.getTestJson(LAYOUT_JSON);
    }

    private JsonNode getL(String key) {
        return this.data.get("layouts").get(key).get("basic");
    }

    private void loadLayout(String lid) {
        JsonNode node = this.getL(lid);
        BasicUiTopoLayoutConfigTest.print("%nJSON loaded: %s", node);
        this.cfg = new BasicUiTopoLayoutConfig();
        this.cfg.init((Object)UiTopoLayoutId.layoutId((String)lid), lid, node, this.mapper, this.delegate);
    }

    private void checkLayout(RegionId expRegion, UiTopoLayoutId expParent, String expGeo, String expSpr) {
        BasicUiTopoLayoutConfigTest.print("   checking: %s", this.cfg);
        Assert.assertEquals((String)"wrong region", (Object)expRegion, (Object)this.cfg.region());
        Assert.assertEquals((String)"wrong parent", (Object)expParent, (Object)this.cfg.parent());
        Assert.assertEquals((String)"wrong geomap", (Object)expGeo, (Object)this.cfg.geomap());
        Assert.assertEquals((String)"wrong sprites", (Object)expSpr, (Object)this.cfg.sprites());
    }

    private void checkScale(double expScale, double expOffx, double expOffy) {
        Assert.assertEquals((String)"scale", (double)expScale, (double)this.cfg.scale(), (double)9.9E-324);
        Assert.assertEquals((String)"offsetX", (double)expOffx, (double)this.cfg.offsetX(), (double)9.9E-324);
        Assert.assertEquals((String)"offsetY", (double)expOffy, (double)this.cfg.offsetY(), (double)9.9E-324);
    }

    @Test
    public void layoutConfigDefault() {
        this.loadLayout(L_DEFAULT);
        this.checkLayout(null, UiTopoLayoutId.DEFAULT_ID, UK, null);
        this.checkScale(1.2, -50.0, 0.0);
    }

    @Test
    public void layoutConfigOne() {
        this.loadLayout(L1);
        this.checkLayout(R1, UiTopoLayoutId.DEFAULT_ID, UK_BRIGHTON, null);
        this.checkScale(0.9, 200.0, -45.0);
    }

    @Test
    public void layoutConfigTwo() {
        this.loadLayout(L2);
        this.checkLayout(R2, UiTopoLayoutId.DEFAULT_ID, UK_LONDON, null);
        this.checkScale(1.0, 0.0, 0.0);
    }

    @Test
    public void layoutConfigThree() {
        this.loadLayout(L3);
        this.checkLayout(R3, UiTopoLayoutId.layoutId((String)L2), null, UK_LONDON_WEST);
        this.checkScale(1.0, 0.0, 0.0);
    }

    private ObjectNode tmpNode(String ... props) {
        return new AbstractConfigTest.TmpJson().props(props).node();
    }

    private BasicUiTopoLayoutConfig cfgFromJson(ObjectNode json) {
        BasicUiTopoLayoutConfig cfg = new BasicUiTopoLayoutConfig();
        cfg.init((Object)UiTopoLayoutId.layoutId((String)"foo"), "basic", (JsonNode)json, this.mapper, this.delegate);
        return cfg;
    }

    @Test(expected=InvalidFieldException.class)
    public void cantHaveGeoAndSprite() {
        this.cfg = this.cfgFromJson(this.tmpNode("geomap", "sprites"));
        this.cfg.isValid();
    }

    @Test(expected=InvalidFieldException.class)
    public void cantSetGeoIfSpritesAreSet() {
        this.cfg = this.cfgFromJson(this.tmpNode("sprites"));
        this.cfg.geomap("map-name");
    }

    @Test(expected=InvalidFieldException.class)
    public void cantSetSpritesIfGeoIsSet() {
        this.cfg = this.cfgFromJson(this.tmpNode("geomap"));
        this.cfg.sprites("sprites-name");
    }

    @Test
    public void setRegion() {
        this.loadLayout(L1);
        Assert.assertEquals((String)"not region-1", (Object)R1, (Object)this.cfg.region());
        this.cfg.region(NEW_REGION);
        Assert.assertEquals((String)"not new region", (Object)NEW_REGION, (Object)this.cfg.region());
        this.cfg.region(null);
        Assert.assertNull((String)"region not cleared", (Object)this.cfg.region());
    }

    @Test
    public void setParent() {
        this.loadLayout(L1);
        Assert.assertEquals((String)"parent not default layout", (Object)UiTopoLayoutId.DEFAULT_ID, (Object)this.cfg.parent());
        this.cfg.parent(NEW_PARENT);
        Assert.assertEquals((String)"not new parent", (Object)NEW_PARENT, (Object)this.cfg.parent());
        this.cfg.parent(null);
        Assert.assertEquals((String)"parent not reset to default", (Object)UiTopoLayoutId.DEFAULT_ID, (Object)this.cfg.parent());
    }

    @Test
    public void setGeomap() {
        this.loadLayout(L1);
        Assert.assertEquals((String)"map not brighton", (Object)UK_BRIGHTON, (Object)this.cfg.geomap());
        this.cfg.geomap(NEW_MAP);
        Assert.assertEquals((String)"not new map", (Object)NEW_MAP, (Object)this.cfg.geomap());
        this.cfg.geomap(null);
        Assert.assertNull((String)"geomap not cleared", (Object)this.cfg.geomap());
    }

    @Test
    public void setSprites() {
        this.loadLayout(L3);
        Assert.assertEquals((String)"sprites not westminster", (Object)UK_LONDON_WEST, (Object)this.cfg.sprites());
        this.cfg.sprites(NEW_SPR);
        Assert.assertEquals((String)"not new sprites", (Object)NEW_SPR, (Object)this.cfg.sprites());
        this.cfg.sprites(null);
        Assert.assertNull((String)"sprites not cleared", (Object)this.cfg.sprites());
    }

    @Test
    public void setScaleAndOffset() {
        this.loadLayout(L1);
        Assert.assertEquals((String)"wrong init scale", (double)0.9, (double)this.cfg.scale(), (double)9.9E-324);
        Assert.assertEquals((String)"wrong init x-offset", (double)200.0, (double)this.cfg.offsetX(), (double)9.9E-324);
        Assert.assertEquals((String)"wrong init y-offset", (double)-45.0, (double)this.cfg.offsetY(), (double)9.9E-324);
        this.cfg.scale(Double.valueOf(3.14)).offsetX(Double.valueOf(12.0)).offsetY(Double.valueOf(13.0));
        Assert.assertEquals((String)"wrong new scale", (double)3.14, (double)this.cfg.scale(), (double)9.9E-324);
        Assert.assertEquals((String)"wrong new x-offset", (double)12.0, (double)this.cfg.offsetX(), (double)9.9E-324);
        Assert.assertEquals((String)"wrong new y-offset", (double)13.0, (double)this.cfg.offsetY(), (double)9.9E-324);
        this.cfg.scale(null).offsetX(null).offsetY(null);
        Assert.assertEquals((String)"wrong default scale", (double)1.0, (double)this.cfg.scale(), (double)9.9E-324);
        Assert.assertEquals((String)"wrong default x-offset", (double)0.0, (double)this.cfg.offsetX(), (double)9.9E-324);
        Assert.assertEquals((String)"wrong default y-offset", (double)0.0, (double)this.cfg.offsetY(), (double)9.9E-324);
    }
}

