/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.testing.EqualsTester;
import java.util.Collection;
import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.flow.BatchOperation;
import org.onosproject.net.flow.BatchOperationEntry;

public class BatchOperationTest {
    final TestEntry entry1 = new TestEntry(TestType.OP1, new TestTarget(1));
    final TestEntry entry2 = new TestEntry(TestType.OP2, new TestTarget(2));

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutableBaseClass(BatchOperation.class);
    }

    @Test
    public void testEquals() {
        LinkedList<TestEntry> ops1 = new LinkedList<TestEntry>();
        ops1.add(this.entry1);
        LinkedList<TestEntry> ops2 = new LinkedList<TestEntry>();
        ops2.add(this.entry2);
        TestOperation op1 = new TestOperation(ops1);
        TestOperation sameAsOp1 = new TestOperation(ops1);
        TestOperation op2 = new TestOperation(ops2);
        new EqualsTester().addEqualityGroup(new Object[]{op1, sameAsOp1}).addEqualityGroup(new Object[]{op2}).testEquals();
    }

    @Test
    public void testConstruction() {
        LinkedList<TestEntry> ops = new LinkedList<TestEntry>();
        ops.add(this.entry2);
        TestOperation op1 = new TestOperation();
        MatcherAssert.assertThat((Object)op1.size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)op1.getOperations(), (Matcher)Matchers.hasSize((int)0));
        TestOperation op2 = new TestOperation(ops);
        op1.addOperation(this.entry1);
        op1.addAll(op2);
        MatcherAssert.assertThat((Object)op1.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)op1.getOperations(), (Matcher)Matchers.hasSize((int)2));
        op2.clear();
        MatcherAssert.assertThat((Object)op2.size(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)op2.getOperations(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testEntryConstruction() {
        TestEntry entry = new TestEntry(TestType.OP3, new TestTarget(3));
        MatcherAssert.assertThat((Object)((Object)((TestType)entry.operator())), (Matcher)Matchers.is((Object)((Object)TestType.OP3)));
        MatcherAssert.assertThat((Object)((TestTarget)entry.target()).id, (Matcher)Matchers.is((Object)3));
    }

    private static final class TestOperation
    extends BatchOperation<TestEntry> {
        private TestOperation() {
        }

        private TestOperation(Collection<TestEntry> batchOperations) {
            super(batchOperations);
        }
    }

    private static final class TestEntry
    extends BatchOperationEntry<TestType, TestTarget> {
        public TestEntry(TestType operator, TestTarget target) {
            super((Enum)operator, (Object)target);
        }
    }

    private static final class TestTarget {
        private int id;

        private TestTarget(int id) {
            this.id = id;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            TestTarget that = (TestTarget)o;
            return this.id == that.id;
        }
    }

    private static enum TestType {
        OP1,
        OP2,
        OP3;

    }
}

