/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.Path;
import org.onosproject.net.intent.AbstractIntentTest;
import org.onosproject.net.intent.OpticalPathIntent;

public class OpticalPathIntentTest
extends AbstractIntentTest {
    static final int PRIORITY = 777;
    OpticalPathIntent intent1;
    OpticalPathIntent intent2;
    Path defaultPath;

    @Before
    public void opticalPathIntentTestSetUp() {
        this.defaultPath = NetTestTools.createPath("a", "b", "c");
        this.intent1 = OpticalPathIntent.builder().appId(NetTestTools.APP_ID).src(NetTestTools.connectPoint("one", 1)).dst(NetTestTools.connectPoint("two", 2)).path(this.defaultPath).lambda(NetTestTools.createLambda()).signalType(OchSignalType.FIXED_GRID).priority(777).build();
        this.intent2 = OpticalPathIntent.builder().appId(NetTestTools.APP_ID).src(NetTestTools.connectPoint("two", 1)).dst(NetTestTools.connectPoint("one", 2)).path(this.defaultPath).lambda(NetTestTools.createLambda()).signalType(OchSignalType.FIXED_GRID).priority(777).build();
    }

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(OpticalPathIntent.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.intent1}).addEqualityGroup(new Object[]{this.intent2}).testEquals();
    }

    @Test
    public void testContents() {
        MatcherAssert.assertThat((Object)this.intent1.appId(), (Matcher)IsEqual.equalTo((Object)NetTestTools.APP_ID));
        MatcherAssert.assertThat((Object)this.intent1.src(), (Matcher)Matchers.equalTo((Object)NetTestTools.connectPoint("one", 1)));
        MatcherAssert.assertThat((Object)this.intent1.dst(), (Matcher)Matchers.equalTo((Object)NetTestTools.connectPoint("two", 2)));
        MatcherAssert.assertThat((Object)this.intent1.priority(), (Matcher)Matchers.is((Object)777));
        MatcherAssert.assertThat((Object)this.intent1.path(), (Matcher)Matchers.is((Object)this.defaultPath));
    }
}

