/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.link;

import com.google.common.testing.EqualsTester;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLinkTest;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.link.DefaultLinkDescription;

public class DefaultLinkDescriptionTest {
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:foo");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:bar");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final DefaultAnnotations DA = DefaultAnnotations.builder().set("Key", "Value").build();

    @Test
    public void basics() {
        DefaultLinkDescription desc = new DefaultLinkDescription(DefaultLinkTest.cp((ElementId)DID1, P1), DefaultLinkTest.cp((ElementId)DID2, P1), Link.Type.DIRECT, new SparseAnnotations[]{DA});
        Assert.assertEquals((String)"incorrect src", (Object)DefaultLinkTest.cp((ElementId)DID1, P1), (Object)desc.src());
        Assert.assertEquals((String)"incorrect dst", (Object)DefaultLinkTest.cp((ElementId)DID2, P1), (Object)desc.dst());
        Assert.assertEquals((String)"incorrect type", (Object)Link.Type.DIRECT, (Object)desc.type());
        Assert.assertTrue((String)"incorrect annotations", (boolean)desc.toString().contains("Key=Value"));
    }

    @Test
    public void testEquals() {
        ConnectPoint connectPoint1 = NetTestTools.connectPoint("sw1", 1);
        ConnectPoint connectPoint2 = NetTestTools.connectPoint("sw2", 2);
        ConnectPoint connectPoint3 = NetTestTools.connectPoint("sw3", 3);
        DefaultLinkDescription link1 = new DefaultLinkDescription(connectPoint1, connectPoint2, Link.Type.DIRECT, new SparseAnnotations[0]);
        DefaultLinkDescription sameAsLink1 = new DefaultLinkDescription(connectPoint1, connectPoint2, Link.Type.DIRECT, new SparseAnnotations[0]);
        DefaultLinkDescription link2 = new DefaultLinkDescription(connectPoint1, connectPoint2, Link.Type.INDIRECT, new SparseAnnotations[0]);
        DefaultLinkDescription link3 = new DefaultLinkDescription(connectPoint1, connectPoint3, Link.Type.DIRECT, new SparseAnnotations[0]);
        DefaultLinkDescription link4 = new DefaultLinkDescription(connectPoint2, connectPoint3, Link.Type.DIRECT, new SparseAnnotations[0]);
        DefaultLinkDescription link5 = new DefaultLinkDescription(connectPoint1, connectPoint2, Link.Type.DIRECT, false, new SparseAnnotations[0]);
        DefaultLinkDescription link6 = new DefaultLinkDescription(connectPoint2, connectPoint3, Link.Type.DIRECT, new SparseAnnotations[]{DA});
        new EqualsTester().addEqualityGroup(new Object[]{link1, sameAsLink1}).addEqualityGroup(new Object[]{link2}).addEqualityGroup(new Object[]{link3}).addEqualityGroup(new Object[]{link4}).addEqualityGroup(new Object[]{link5}).addEqualityGroup(new Object[]{link6}).testEquals();
    }
}

