/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiActionId;
import org.onosproject.net.pi.model.PiActionParamId;
import org.onosproject.net.pi.model.PiActionProfileId;
import org.onosproject.net.pi.runtime.PiAction;
import org.onosproject.net.pi.runtime.PiActionParam;
import org.onosproject.net.pi.runtime.PiActionProfileMember;
import org.onosproject.net.pi.runtime.PiActionProfileMemberId;

public class PiActionProfileMemberTest {
    private final PiActionProfileId actionProfileId1 = PiActionProfileId.of((String)"foo");
    private final PiActionProfileId actionProfileId2 = PiActionProfileId.of((String)"bar");
    private final PiActionProfileMemberId piActionProfileMemberId1 = PiActionProfileMemberId.of((int)10);
    private final PiActionProfileMemberId piActionProfileMemberId2 = PiActionProfileMemberId.of((int)20);
    private final PiAction piAction1 = PiAction.builder().withId(PiActionId.of((String)"mod_nw_dst")).withParameter(new PiActionParam(PiActionParamId.of((String)"dstAddr"), ImmutableByteSequence.copyFrom((int)0xA010101))).build();
    private final PiAction piAction2 = PiAction.builder().withId(PiActionId.of((String)"mod_vlan_vid")).withParameter(new PiActionParam(PiActionParamId.of((String)"vid"), ImmutableByteSequence.copyFrom((int)11))).build();
    private final PiActionProfileMember piActionProfileMember1 = PiActionProfileMember.builder().forActionProfile(this.actionProfileId1).withId(this.piActionProfileMemberId1).withAction(this.piAction1).build();
    private final PiActionProfileMember sameAsPiActionProfileMember1 = PiActionProfileMember.builder().forActionProfile(this.actionProfileId1).withId(this.piActionProfileMemberId1).withAction(this.piAction1).build();
    private final PiActionProfileMember piActionProfileMember2 = PiActionProfileMember.builder().forActionProfile(this.actionProfileId1).withId(this.piActionProfileMemberId2).withAction(this.piAction2).build();
    private final PiActionProfileMember piActionProfileMember3 = PiActionProfileMember.builder().forActionProfile(this.actionProfileId2).withId(this.piActionProfileMemberId1).withAction(this.piAction1).build();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiActionProfileMember.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piActionProfileMember1, this.sameAsPiActionProfileMember1}).addEqualityGroup(new Object[]{this.piActionProfileMember2}).addEqualityGroup(new Object[]{this.piActionProfileMember3}).testEquals();
    }

    @Test
    public void testMethods() {
        MatcherAssert.assertThat((Object)this.piActionProfileMember1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.piActionProfileMember1.id(), (Matcher)Matchers.is((Object)this.piActionProfileMemberId1));
        MatcherAssert.assertThat((Object)this.piActionProfileMember1.action(), (Matcher)Matchers.is((Object)this.piAction1));
    }
}

