/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onosproject.net.PortNumber;
import org.onosproject.net.pi.runtime.PiMulticastGroupEntry;
import org.onosproject.net.pi.runtime.PiPreReplica;

public class PiMulticastGroupEntryTest {
    private final int groupId1 = 1;
    private final int groupId2 = 2;
    private final int instanceId1 = 1;
    private final PortNumber port1 = PortNumber.portNumber((long)1L);
    private final PortNumber port2 = PortNumber.portNumber((long)2L);
    private final PortNumber port3 = PortNumber.portNumber((long)3L);
    private final PiPreReplica replica1 = new PiPreReplica(this.port1, 1);
    private final PiPreReplica replica2 = new PiPreReplica(this.port2, 1);
    private final PiPreReplica replica3 = new PiPreReplica(this.port3, 1);
    private final PiMulticastGroupEntry group1 = PiMulticastGroupEntry.builder().withGroupId(1).addReplica(this.replica1).addReplica(this.replica2).build();
    private final PiMulticastGroupEntry sameAsGroup1 = PiMulticastGroupEntry.builder().withGroupId(1).addReplica(this.replica1).addReplica(this.replica2).build();
    private final PiMulticastGroupEntry group2 = PiMulticastGroupEntry.builder().withGroupId(2).addReplica(this.replica1).addReplica(this.replica2).addReplica(this.replica3).build();

    @Test
    public void testPiMulticastGroupEntry() {
        MatcherAssert.assertThat((String)"Invalid group ID", (Object)this.group1.groupId(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Invalid replicas size", (Object)this.group1.replicas().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((String)"Invalid replicas", (Object)this.group1.replicas(), (Matcher)Matchers.contains((Object[])new PiPreReplica[]{this.replica1, this.replica2}));
        MatcherAssert.assertThat((String)"Invalid group ID", (Object)this.group2.groupId(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((String)"Invalid replicas size", (Object)this.group2.replicas().size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((String)"Invalid replicas", (Object)this.group2.replicas(), (Matcher)Matchers.contains((Object[])new PiPreReplica[]{this.replica1, this.replica2, this.replica3}));
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.group1, this.sameAsGroup1}).addEqualityGroup(new Object[]{this.group2}).testEquals();
    }
}

