/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.region;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.region.DefaultRegion;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;

public class DefaultRegionTest {
    private static final RegionId ID1 = RegionId.regionId((String)"r1");
    private static final Annotations NO_ANNOTS = DefaultAnnotations.EMPTY;

    @Test
    public void basics() {
        ImmutableList masters = ImmutableList.of((Object)ImmutableSet.of((Object)NodeId.nodeId((String)"n1"), (Object)NodeId.nodeId((String)"n2")), (Object)ImmutableSet.of((Object)NodeId.nodeId((String)"n3"), (Object)NodeId.nodeId((String)"n4")));
        DefaultRegion r = new DefaultRegion(ID1, "R1", Region.Type.METRO, NO_ANNOTS, (List)masters);
        Assert.assertEquals((String)"incorrect id", (Object)ID1, (Object)r.id());
        Assert.assertEquals((String)"incorrect name", (Object)"R1", (Object)r.name());
        Assert.assertEquals((String)"incorrect type", (Object)Region.Type.METRO, (Object)r.type());
        Assert.assertEquals((String)"incorrect masters", (Object)masters, (Object)r.masters());
    }

    @Test
    public void equality() {
        DefaultRegion a = new DefaultRegion(ID1, "R1", Region.Type.METRO, NO_ANNOTS, null);
        DefaultRegion b = new DefaultRegion(ID1, "R1", Region.Type.METRO, NO_ANNOTS, null);
        DefaultRegion c = new DefaultRegion(ID1, "R2", Region.Type.METRO, NO_ANNOTS, null);
        new EqualsTester().addEqualityGroup(new Object[]{a, b}).addEqualityGroup(new Object[]{c}).testEquals();
    }
}

