/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.statistic;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.StoredFlowEntryAdapter;
import org.onosproject.net.statistic.DefaultLoad;
import org.onosproject.net.statistic.FlowEntryWithLoad;
import org.onosproject.net.statistic.Load;

public class FlowEntryWithLoadTest {
    @Test
    public void testConstructionCpFeLoad() {
        ConnectPoint cp = NetTestTools.connectPoint("id1", 1);
        MockFlowEntry fe = new MockFlowEntry(FlowEntry.FlowLiveType.IMMEDIATE);
        DefaultLoad load = new DefaultLoad();
        FlowEntryWithLoad underTest = new FlowEntryWithLoad(cp, (FlowEntry)fe, (Load)load);
        MatcherAssert.assertThat((Object)underTest.connectPoint(), (Matcher)Matchers.is((Object)cp));
        MatcherAssert.assertThat((Object)underTest.load(), (Matcher)Matchers.is((Object)load));
        MatcherAssert.assertThat((Object)underTest.storedFlowEntry(), (Matcher)Matchers.is((Object)fe));
    }

    @Test
    public void testConstructionDEfaultLoad() {
        ConnectPoint cp = NetTestTools.connectPoint("id1", 1);
        MockFlowEntry fe = new MockFlowEntry(FlowEntry.FlowLiveType.IMMEDIATE);
        fe = new MockFlowEntry(FlowEntry.FlowLiveType.IMMEDIATE);
        FlowEntryWithLoad underTest = new FlowEntryWithLoad(cp, (FlowEntry)fe);
        MatcherAssert.assertThat((Object)underTest.connectPoint(), (Matcher)Matchers.is((Object)cp));
        MatcherAssert.assertThat((Object)underTest.load(), (Matcher)Matchers.instanceOf(DefaultLoad.class));
        MatcherAssert.assertThat((Object)underTest.storedFlowEntry(), (Matcher)Matchers.is((Object)fe));
        fe = new MockFlowEntry(FlowEntry.FlowLiveType.LONG);
        underTest = new FlowEntryWithLoad(cp, (FlowEntry)fe);
        MatcherAssert.assertThat((Object)underTest.connectPoint(), (Matcher)Matchers.is((Object)cp));
        MatcherAssert.assertThat((Object)underTest.load(), (Matcher)Matchers.instanceOf(DefaultLoad.class));
        fe = new MockFlowEntry(FlowEntry.FlowLiveType.MID);
        underTest = new FlowEntryWithLoad(cp, (FlowEntry)fe);
        MatcherAssert.assertThat((Object)underTest.connectPoint(), (Matcher)Matchers.is((Object)cp));
        MatcherAssert.assertThat((Object)underTest.load(), (Matcher)Matchers.instanceOf(DefaultLoad.class));
        fe = new MockFlowEntry(FlowEntry.FlowLiveType.SHORT);
        underTest = new FlowEntryWithLoad(cp, (FlowEntry)fe);
        MatcherAssert.assertThat((Object)underTest.connectPoint(), (Matcher)Matchers.is((Object)cp));
        MatcherAssert.assertThat((Object)underTest.load(), (Matcher)Matchers.instanceOf(DefaultLoad.class));
        fe = new MockFlowEntry(FlowEntry.FlowLiveType.UNKNOWN);
        underTest = new FlowEntryWithLoad(cp, (FlowEntry)fe);
        MatcherAssert.assertThat((Object)underTest.connectPoint(), (Matcher)Matchers.is((Object)cp));
        MatcherAssert.assertThat((Object)underTest.load(), (Matcher)Matchers.instanceOf(DefaultLoad.class));
    }

    class MockFlowEntry
    extends StoredFlowEntryAdapter {
        FlowEntry.FlowLiveType liveType;

        public MockFlowEntry(FlowEntry.FlowLiveType liveType) {
            this.liveType = liveType;
        }

        @Override
        public FlowEntry.FlowLiveType liveType() {
            return this.liveType;
        }
    }
}

