/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.store.primitives.AsyncConsistentTreeMapAdapter;
import org.onosproject.store.primitives.DefaultConsistentTreeMap;
import org.onosproject.store.primitives.TestingCompletableFutures;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Versioned;

public class DefaultConsistentTreeMapTest {
    private static final String MIN_KEY = "0";
    private static final String KEY1 = "A";
    private static final String VALUE1 = "A";
    private static final String KEY2 = "B";
    private static final String VALUE2 = "B";
    private static final String KEY3 = "C";
    private static final String VALUE3 = "C";
    private static final String KEY4 = "D";
    private static final String VALUE4 = "D";
    private static final String KEY5 = "E";
    private static final String VALUE5 = "E";
    private static final String MAX_KEY = "Z";
    private static final String NO_SUCH_VALUE = "BAD VALUE";
    private static final String NO_SUCH_KEY = "BAD KEY";
    private static final String DEFAULT_VALUE = "DEFAULT";
    private DefaultConsistentTreeMap<String> treeMap;
    private TestAsyncConsistentTreeMap<String> asyncMap;

    private DefaultConsistentTreeMap<String> createMap() {
        this.asyncMap = new TestAsyncConsistentTreeMap();
        DefaultConsistentTreeMap map = new DefaultConsistentTreeMap(this.asyncMap, 1000L);
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)map.isEmpty(), (Matcher)Matchers.is((Object)true));
        map.putIfAbsent("A", (Object)"A");
        map.putIfAbsent("B", (Object)"B");
        map.putIfAbsent("C", (Object)"C");
        return map;
    }

    private static VersionedMatcher matchesVersioned(String expectedValue) {
        return new VersionedMatcher(expectedValue);
    }

    @Before
    public void setUpMap() {
        this.treeMap = this.createMap();
    }

    @Test
    public void testKeys() {
        MatcherAssert.assertThat((Object)this.treeMap.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)this.treeMap.navigableKeySet(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)this.treeMap.firstKey(), (Matcher)Matchers.is((Object)"A"));
        MatcherAssert.assertThat((Object)this.treeMap.lastKey(), (Matcher)Matchers.is((Object)"C"));
        MatcherAssert.assertThat((Object)this.treeMap.lowerKey("B"), (Matcher)Matchers.is((Object)"A"));
        MatcherAssert.assertThat((Object)this.treeMap.higherKey("B"), (Matcher)Matchers.is((Object)"C"));
        MatcherAssert.assertThat((Object)this.treeMap.floorKey(MAX_KEY), (Matcher)Matchers.is((Object)"C"));
        MatcherAssert.assertThat((Object)this.treeMap.ceilingKey(MIN_KEY), (Matcher)Matchers.is((Object)"A"));
        MatcherAssert.assertThat((Object)this.treeMap.containsKey("B"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.treeMap.containsKey(MAX_KEY), (Matcher)Matchers.is((Object)false));
    }

    private void checkEntry(Map.Entry<String, Versioned<String>> entry, String expectedKey, String expectedValue) {
        MatcherAssert.assertThat((Object)entry.getKey(), (Matcher)Matchers.is((Object)expectedKey));
        MatcherAssert.assertThat(entry.getValue(), (Matcher)DefaultConsistentTreeMapTest.matchesVersioned(expectedValue));
    }

    @Test
    public void testEntries() {
        MatcherAssert.assertThat((Object)this.treeMap.size(), (Matcher)Matchers.is((Object)3));
        this.checkEntry(this.treeMap.firstEntry(), "A", "A");
        this.checkEntry(this.treeMap.lastEntry(), "C", "C");
        this.checkEntry(this.treeMap.lowerEntry("B"), "A", "A");
        this.checkEntry(this.treeMap.higherEntry("B"), "C", "C");
        this.checkEntry(this.treeMap.floorEntry(MAX_KEY), "C", "C");
        this.checkEntry(this.treeMap.ceilingEntry(MIN_KEY), "A", "A");
        this.checkEntry(this.treeMap.pollFirstEntry(), "A", "A");
        MatcherAssert.assertThat((Object)this.treeMap.size(), (Matcher)Matchers.is((Object)2));
        this.checkEntry(this.treeMap.pollLastEntry(), "C", "C");
        MatcherAssert.assertThat((Object)this.treeMap.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testGets() {
        MatcherAssert.assertThat((Object)this.treeMap.get("B"), (Matcher)DefaultConsistentTreeMapTest.matchesVersioned("B"));
        MatcherAssert.assertThat((Object)this.treeMap.containsValue((Object)"C"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.treeMap.getOrDefault("C", (Object)DEFAULT_VALUE), (Matcher)DefaultConsistentTreeMapTest.matchesVersioned("C"));
        MatcherAssert.assertThat((Object)this.treeMap.getOrDefault(NO_SUCH_KEY, (Object)DEFAULT_VALUE), (Matcher)DefaultConsistentTreeMapTest.matchesVersioned(DEFAULT_VALUE));
        MatcherAssert.assertThat((Object)this.treeMap.compute("D", (k, v) -> v == null ? "D" : ""), (Matcher)DefaultConsistentTreeMapTest.matchesVersioned("D"));
        MatcherAssert.assertThat((Object)this.treeMap.computeIf("D", Objects::isNull, (k, v) -> NO_SUCH_VALUE), (Matcher)DefaultConsistentTreeMapTest.matchesVersioned("D"));
        MatcherAssert.assertThat((Object)this.treeMap.computeIfPresent("D", (k, v) -> NO_SUCH_VALUE), (Matcher)DefaultConsistentTreeMapTest.matchesVersioned(NO_SUCH_VALUE));
        MatcherAssert.assertThat((Object)this.treeMap.computeIfAbsent("B", v -> NO_SUCH_VALUE), (Matcher)DefaultConsistentTreeMapTest.matchesVersioned("B"));
        this.treeMap.put("E", (Object)"E");
        MatcherAssert.assertThat((Object)this.treeMap.putAndGet("E", (Object)"A"), (Matcher)DefaultConsistentTreeMapTest.matchesVersioned("E"));
        MatcherAssert.assertThat((Object)this.treeMap.get("E"), (Matcher)DefaultConsistentTreeMapTest.matchesVersioned("A"));
    }

    @Test
    public void testSets() {
        Set keys = this.treeMap.keySet();
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)keys, (Matcher)Matchers.hasItems((Object[])new String[]{"A", "B", "C"}));
        Set values = this.treeMap.values().stream().map(Versioned::value).collect(Collectors.toSet());
        MatcherAssert.assertThat(values, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(values, (Matcher)Matchers.hasItems((Object[])new String[]{"A", "B", "C"}));
        Set valuesFromEntries = this.treeMap.entrySet().stream().map(entry -> (String)((Versioned)entry.getValue()).value()).collect(Collectors.toSet());
        MatcherAssert.assertThat(valuesFromEntries, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(valuesFromEntries, (Matcher)Matchers.hasItems((Object[])new String[]{"A", "B", "C"}));
        Set keysFromEntries = this.treeMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
        MatcherAssert.assertThat(keysFromEntries, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(keysFromEntries, (Matcher)Matchers.hasItems((Object[])new String[]{"A", "B", "C"}));
    }

    @Test
    public void testRemoves() {
        this.treeMap.remove("A");
        MatcherAssert.assertThat((Object)this.treeMap.size(), (Matcher)Matchers.is((Object)2));
        this.treeMap.remove("B", 1L);
        MatcherAssert.assertThat((Object)this.treeMap.size(), (Matcher)Matchers.is((Object)1));
        this.treeMap.remove("C", (Object)"C");
        MatcherAssert.assertThat((Object)this.treeMap.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testClear() {
        this.treeMap.clear();
        MatcherAssert.assertThat((Object)this.treeMap.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testReplaces() {
        this.treeMap.replace("A", (Object)"B");
        MatcherAssert.assertThat((Object)this.treeMap.get("A"), (Matcher)DefaultConsistentTreeMapTest.matchesVersioned("B"));
        this.treeMap.replace("B", 1L, (Object)"A");
        MatcherAssert.assertThat((Object)this.treeMap.get("B"), (Matcher)DefaultConsistentTreeMapTest.matchesVersioned("A"));
        this.treeMap.replace("C", (Object)"C", (Object)"E");
        MatcherAssert.assertThat((Object)this.treeMap.get("C"), (Matcher)DefaultConsistentTreeMapTest.matchesVersioned("E"));
    }

    @Test
    public void testJavaMap() {
        Map javaMap = this.treeMap.asJavaMap();
        MatcherAssert.assertThat(javaMap.entrySet(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(javaMap.values(), (Matcher)Matchers.hasItems((Object[])new String[]{"A", "B", "C"}));
        MatcherAssert.assertThat(javaMap.keySet(), (Matcher)Matchers.hasItems((Object[])new String[]{"A", "B", "C"}));
    }

    @Test
    public void testSubMap() {
        this.treeMap.putIfAbsent("D", (Object)"D");
        this.treeMap.putIfAbsent("E", (Object)"E");
        NavigableMap subMap = this.treeMap.subMap("B", "D", true, true);
        MatcherAssert.assertThat(subMap.entrySet(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(subMap.values(), (Matcher)Matchers.hasItems((Object[])new String[]{"B", "C", "D"}));
        MatcherAssert.assertThat(subMap.keySet(), (Matcher)Matchers.hasItems((Object[])new String[]{"B", "C", "D"}));
    }

    @Test
    public void testListeners() {
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        MatcherAssert.assertThat(this.asyncMap.listeners, (Matcher)Matchers.hasSize((int)0));
        this.treeMap.addListener((MapEventListener)listener1);
        MatcherAssert.assertThat(this.asyncMap.listeners, (Matcher)Matchers.hasSize((int)1));
        this.treeMap.addListener((MapEventListener)listener2);
        MatcherAssert.assertThat(this.asyncMap.listeners, (Matcher)Matchers.hasSize((int)2));
        this.treeMap.removeListener((MapEventListener)listener1);
        this.treeMap.removeListener((MapEventListener)listener2);
        MatcherAssert.assertThat(this.asyncMap.listeners, (Matcher)Matchers.hasSize((int)0));
    }

    @Test(expected=ConsistentMapException.Timeout.class)
    public void testTimeout() {
        ConsistentTreeMapWithError consistentMap = new ConsistentTreeMapWithError();
        consistentMap.setErrorState(TestingCompletableFutures.ErrorState.TIMEOUT_EXCEPTION);
        DefaultConsistentTreeMap map = new DefaultConsistentTreeMap(consistentMap, 1000L);
        map.lowerKey("A");
    }

    @Test(expected=ConsistentMapException.Interrupted.class)
    public void testInterrupted() {
        ConsistentTreeMapWithError consistentMap = new ConsistentTreeMapWithError();
        consistentMap.setErrorState(TestingCompletableFutures.ErrorState.INTERRUPTED_EXCEPTION);
        DefaultConsistentTreeMap map = new DefaultConsistentTreeMap(consistentMap, 1000L);
        map.lowerKey("A");
    }

    @Test(expected=ConsistentMapException.class)
    public void testExecutionError() {
        ConsistentTreeMapWithError consistentMap = new ConsistentTreeMapWithError();
        consistentMap.setErrorState(TestingCompletableFutures.ErrorState.EXECUTION_EXCEPTION);
        DefaultConsistentTreeMap map = new DefaultConsistentTreeMap(consistentMap, 1000L);
        map.lowerKey("A");
    }

    class ConsistentTreeMapWithError<K>
    extends AsyncConsistentTreeMapAdapter<K> {
        TestingCompletableFutures.ErrorState errorState = TestingCompletableFutures.ErrorState.NONE;

        void setErrorState(TestingCompletableFutures.ErrorState errorState) {
            this.errorState = errorState;
        }

        ConsistentTreeMapWithError() {
        }

        @Override
        public CompletableFuture<String> lowerKey(String key) {
            return TestingCompletableFutures.createStringFuture(this.errorState);
        }
    }

    static class VersionedMatcher
    extends TypeSafeMatcher<Versioned<String>> {
        String expectedValue;

        VersionedMatcher(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        public boolean matchesSafely(Versioned<String> value) {
            return this.expectedValue.equals(value.value());
        }

        public void describeTo(Description description) {
            description.appendText("<Versioned{value=" + this.expectedValue + ",...");
        }
    }

    class Listener
    implements MapEventListener<String, String> {
        Listener() {
        }

        public void event(MapEvent<String, String> event) {
        }
    }

    private static class TestAsyncConsistentTreeMap<V>
    extends AsyncConsistentTreeMapAdapter<V> {
        LinkedList<MapEventListener<String, V>> listeners = new LinkedList();

        private TestAsyncConsistentTreeMap() {
        }

        @Override
        public CompletableFuture<Void> addListener(MapEventListener<String, V> listener, Executor executor) {
            this.listeners.add(listener);
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> removeListener(MapEventListener<String, V> listener) {
            this.listeners.remove(listener);
            return CompletableFuture.completedFuture(null);
        }
    }
}

