/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.util.concurrent.AtomicLongMap;
import org.onosproject.store.service.AsyncAtomicCounterMap;
import org.onosproject.store.service.AtomicCounterMap;
import org.onosproject.store.service.AtomicCounterMapAdapter;
import org.onosproject.store.service.AtomicCounterMapBuilder;

public final class TestAtomicCounterMap<K>
extends AtomicCounterMapAdapter<K> {
    private final String atomicCounterMapName;
    private AtomicLongMap<K> map;

    private TestAtomicCounterMap(String name) {
        this.atomicCounterMapName = name;
        this.map = AtomicLongMap.create();
    }

    @Override
    public long incrementAndGet(K key) {
        return this.map.incrementAndGet(key);
    }

    @Override
    public long decrementAndGet(K key) {
        return this.map.decrementAndGet(key);
    }

    @Override
    public long getAndIncrement(K key) {
        return this.map.getAndIncrement(key);
    }

    @Override
    public long getAndDecrement(K key) {
        return this.map.getAndDecrement(key);
    }

    @Override
    public long addAndGet(K key, long delta) {
        return this.map.addAndGet(key, delta);
    }

    @Override
    public long getAndAdd(K key, long delta) {
        return this.map.getAndAdd(key, delta);
    }

    @Override
    public long get(K key) {
        return this.map.get(key);
    }

    @Override
    public long put(K key, long newValue) {
        return this.map.put(key, newValue);
    }

    @Override
    public long putIfAbsent(K key, long newValue) {
        if (!this.map.containsKey(key)) {
            return this.map.put(key, newValue);
        }
        return this.map.get(key);
    }

    @Override
    public boolean replace(K key, long expectedOldValue, long newValue) {
        if (this.map.containsKey(key) && this.map.get(key) == expectedOldValue) {
            this.map.put(key, newValue);
            return true;
        }
        if (!this.map.containsKey(key) && expectedOldValue == 0L) {
            this.map.put(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public long remove(K key) {
        return this.map.remove(key);
    }

    @Override
    public boolean remove(K key, long value) {
        if (this.map.containsKey(key) && this.map.get(key) == value) {
            this.map.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public String name() {
        return this.atomicCounterMapName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<K>
    extends AtomicCounterMapBuilder<K> {
        public AtomicCounterMap<K> build() {
            return new TestAtomicCounterMap(this.name());
        }

        public AsyncAtomicCounterMap<K> buildAsyncMap() {
            return null;
        }
    }
}

