/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Objects;
import java.util.TreeMap;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.DocumentTreeNode;
import org.onosproject.store.service.Versioned;

public class TestDocumentTreeNode<V>
implements DocumentTreeNode<V> {
    private final DocumentPath key;
    private Versioned<V> value;
    private final TreeMap<String, DocumentTreeNode<V>> children = Maps.newTreeMap();
    private final DocumentTreeNode<V> parent;

    public TestDocumentTreeNode(DocumentPath key, V value, long version, DocumentTreeNode<V> parent) {
        this.key = (DocumentPath)Preconditions.checkNotNull((Object)key);
        this.value = new Versioned(value, version);
        this.parent = parent;
    }

    public DocumentPath path() {
        return this.key;
    }

    public Versioned<V> value() {
        return this.value;
    }

    public Iterator<DocumentTreeNode<V>> children() {
        return ImmutableList.copyOf(this.children.values()).iterator();
    }

    public DocumentTreeNode<V> child(String name) {
        return this.children.get(name);
    }

    public DocumentTreeNode<V> parent() {
        return this.parent;
    }

    public Versioned<V> addChild(String name, V newValue, long newVersion) {
        TestDocumentTreeNode child = (TestDocumentTreeNode)this.children.get(name);
        if (child != null) {
            return child.value();
        }
        this.children.put(name, new TestDocumentTreeNode<V>(new DocumentPath(name, this.path()), newValue, newVersion, this));
        return null;
    }

    public Versioned<V> update(V newValue, long newVersion) {
        Versioned<V> previousValue = this.value;
        this.value = new Versioned(newValue, newVersion);
        return previousValue;
    }

    public boolean removeChild(String name) {
        return this.children.remove(name) != null;
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestDocumentTreeNode) {
            TestDocumentTreeNode that = (TestDocumentTreeNode)obj;
            if (this.parent.equals(that.parent) && this.children.size() == that.children.size()) {
                return Sets.symmetricDifference(this.children.keySet(), that.children.keySet()).isEmpty();
            }
        }
        return false;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this.getClass()).add("parent", this.parent).add("key", (Object)this.key).add("value", this.value);
        for (DocumentTreeNode<V> child : this.children.values()) {
            helper = helper.add("child", (Object)("\n" + (String)child.path().pathElements().get(child.path().pathElements().size() - 1) + " : " + child.value()));
        }
        return helper.toString();
    }
}

