/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.Timestamp;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapAdapter;
import org.onosproject.store.service.EventuallyConsistentMapBuilder;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;

public final class TestEventuallyConsistentMap<K, V>
extends EventuallyConsistentMapAdapter<K, V> {
    private final HashMap<K, V> map = new HashMap();
    private final String mapName;
    private final List<EventuallyConsistentMapListener<K, V>> listeners = new LinkedList<EventuallyConsistentMapListener<K, V>>();
    private final BiFunction<K, V, Collection<NodeId>> peerUpdateFunction;

    private TestEventuallyConsistentMap(String mapName, BiFunction<K, V, Collection<NodeId>> peerUpdateFunction) {
        this.mapName = mapName;
        this.peerUpdateFunction = peerUpdateFunction;
    }

    private void notifyListeners(EventuallyConsistentMapEvent<K, V> event) {
        this.listeners.forEach(listener -> listener.event(event));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.map.put(key, value);
        EventuallyConsistentMapEvent addEvent = new EventuallyConsistentMapEvent(this.mapName, EventuallyConsistentMapEvent.Type.PUT, key, value);
        this.notifyListeners(addEvent);
        if (this.peerUpdateFunction != null) {
            this.peerUpdateFunction.apply(key, value);
        }
    }

    @Override
    public V remove(K key) {
        V result = this.map.remove(key);
        if (result != null) {
            EventuallyConsistentMapEvent removeEvent = new EventuallyConsistentMapEvent(this.mapName, EventuallyConsistentMapEvent.Type.REMOVE, key, result);
            this.notifyListeners(removeEvent);
        }
        return result;
    }

    @Override
    public void remove(K key, V value) {
        boolean removed = this.map.remove(key, value);
        if (removed) {
            EventuallyConsistentMapEvent removeEvent = new EventuallyConsistentMapEvent(this.mapName, EventuallyConsistentMapEvent.Type.REMOVE, key, value);
            this.notifyListeners(removeEvent);
        }
    }

    @Override
    public V compute(K key, BiFunction<K, V, V> recomputeFunction) {
        return this.map.compute(key, recomputeFunction);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    @Override
    public void addListener(EventuallyConsistentMapListener<K, V> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(EventuallyConsistentMapListener<K, V> listener) {
        this.listeners.remove(listener);
    }

    public static class Builder<K, V>
    implements EventuallyConsistentMapBuilder<K, V> {
        private String name;
        private BiFunction<K, V, Collection<NodeId>> peerUpdateFunction;

        public EventuallyConsistentMapBuilder<K, V> withName(String name) {
            this.name = name;
            return this;
        }

        public EventuallyConsistentMapBuilder<K, V> withSerializer(KryoNamespace.Builder serializerBuilder) {
            return this;
        }

        public EventuallyConsistentMapBuilder<K, V> withSerializer(KryoNamespace serializer) {
            return this;
        }

        public EventuallyConsistentMapBuilder<K, V> withTimestampProvider(BiFunction<K, V, Timestamp> timestampProvider) {
            return this;
        }

        public EventuallyConsistentMapBuilder<K, V> withEventExecutor(ExecutorService executor) {
            return this;
        }

        public EventuallyConsistentMapBuilder<K, V> withCommunicationExecutor(ExecutorService executor) {
            return this;
        }

        public EventuallyConsistentMapBuilder<K, V> withBackgroundExecutor(ScheduledExecutorService executor) {
            return this;
        }

        public EventuallyConsistentMapBuilder<K, V> withPeerUpdateFunction(BiFunction<K, V, Collection<NodeId>> peerUpdateFunction) {
            this.peerUpdateFunction = peerUpdateFunction;
            return this;
        }

        public EventuallyConsistentMapBuilder<K, V> withTombstonesDisabled() {
            return this;
        }

        public EventuallyConsistentMapBuilder<K, V> withAntiEntropyPeriod(long period, TimeUnit unit) {
            return this;
        }

        public EventuallyConsistentMapBuilder<K, V> withFasterConvergence() {
            return this;
        }

        public EventuallyConsistentMapBuilder<K, V> withPersistence() {
            return this;
        }

        public EventuallyConsistentMap<K, V> build() {
            if (this.name == null) {
                this.name = "test";
            }
            return new TestEventuallyConsistentMap<K, V>(this.name, this.peerUpdateFunction);
        }
    }
}

